/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper;

import com.github.yannicklamprecht.worldborder.api.BorderAPI;
import com.github.yannicklamprecht.worldborder.api.WorldBorderApi;
import com.karuslabs.commons.command.dispatcher.Dispatcher;
import java.nio.file.Path;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.account.AccountStore;
import tr.com.infumia.infumialib.account.LogInOut;
import tr.com.infumia.infumialib.dynamism.DynamicRegistry;
import tr.com.infumia.infumialib.files.InfumiaLibConfig;
import tr.com.infumia.infumialib.kubernetes.Kubernetes;
import tr.com.infumia.infumialib.log.LogService;
import tr.com.infumia.infumialib.messengers.GameplayMessenger;
import tr.com.infumia.infumialib.misc.GitHubUpdateChecker;
import tr.com.infumia.infumialib.platform.paper.InfumiaLib;
import tr.com.infumia.infumialib.platform.paper.Metrics;
import tr.com.infumia.infumialib.platform.paper.account.BukkitLogInOutListener;
import tr.com.infumia.infumialib.platform.paper.border.Border;
import tr.com.infumia.infumialib.platform.paper.border.PersistenceWrapper;
import tr.com.infumia.infumialib.platform.paper.color.CustomColors;
import tr.com.infumia.infumialib.platform.paper.commands.Commands;
import tr.com.infumia.infumialib.platform.paper.files.PaperConfig;
import tr.com.infumia.infumialib.platform.paper.hooks.Hooks;
import tr.com.infumia.infumialib.platform.paper.messaging.BukkitTravel;
import tr.com.infumia.infumialib.platform.paper.utils.TaskUtilities;

final class Initializer {
    private static final Object FILE_LOCK = new Object();
    @Nullable
    private static Dispatcher dispatcher;

    @NotNull
    static Dispatcher dispatcher(@NotNull InfumiaLib plugin) {
        if (dispatcher == null) {
            dispatcher = Dispatcher.of((Plugin)plugin);
        }
        return dispatcher;
    }

    static void enable(@NotNull InfumiaLib plugin) {
        Hooks.loadHooks();
        Initializer.initiateWorldBorder(plugin);
        dispatcher = Dispatcher.of((Plugin)plugin);
        Commands.register(plugin);
        InfumiaLib.inventory().init();
        Initializer.checkForUpdate(plugin);
        new Metrics((Plugin)plugin, 11422);
        Initializer.startMultiServer(plugin);
    }

    static void load(@NotNull InfumiaLib plugin) {
        CustomColors.registerAll();
        TaskUtilities.init((Plugin)plugin);
        Initializer.loadFiles(plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadFiles(@NotNull InfumiaLib plugin) {
        Object object = FILE_LOCK;
        synchronized (object) {
            Path path = plugin.getDataFolder().toPath();
            InfumiaLibConfig.loadConfig(path.resolve("config.yml"));
            PaperConfig.loadConfig(path.resolve("paper.yml"));
        }
    }

    private static void checkForUpdate(@NotNull InfumiaLib plugin) {
        if (!InfumiaLibConfig.checkForUpdate) {
            return;
        }
        PluginDescriptionFile description = plugin.getDescription();
        GitHubUpdateChecker.checkForUpdate((Audience)Bukkit.getConsoleSender(), plugin.getSLF4JLogger(), description.getVersion(), description.getName(), "Infumia", "InfumiaLib");
    }

    private static void initiateWorldBorder(@NotNull InfumiaLib plugin) {
        try {
            PersistenceWrapper worldBorderApi = new PersistenceWrapper(plugin, (WorldBorderApi)new Border());
            plugin.getServer().getServicesManager().register(WorldBorderApi.class, (Object)worldBorderApi, (Plugin)plugin, ServicePriority.High);
            BorderAPI.setWorldBorderApi((WorldBorderApi)worldBorderApi);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void startMultiServer(@NotNull InfumiaLib plugin) {
        if (!PaperConfig.multiServer) {
            return;
        }
        Kubernetes.initClient();
        Kubernetes.initRedis(PaperConfig.redisPassword);
        GameplayMessenger gameplayMessenger = new GameplayMessenger(PaperConfig.serverGroup);
        BukkitTravel travel = new BukkitTravel((Plugin)plugin, gameplayMessenger);
        LogService logService = new LogService(PaperConfig.serverName);
        DynamicRegistry dynamicRegistry = new DynamicRegistry();
        AccountStore accountStore = AccountStore.create();
        LogInOut logInOut = LogInOut.create(accountStore, logService, dynamicRegistry);
        BukkitLogInOutListener log = new BukkitLogInOutListener(logInOut);
        Bukkit.getPluginManager().registerEvents((Listener)travel, (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)log, (Plugin)plugin);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, logService::push, 20L, 20L);
    }

    private Initializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

