/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.scoreboard;

import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.scoreboard.BukkitScoreboardSender;
import tr.com.infumia.infumialib.platform.paper.scoreboard.BukkitScoreboardThread;

public final class BukkitScoreboard
implements Listener,
AutoCloseable {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final BukkitScoreboardThread thread;

    @NotNull
    public static BukkitScoreboard create(@NotNull Plugin plugin, long tick) {
        return new BukkitScoreboard(plugin, new BukkitScoreboardThread(new BukkitScoreboardSender(plugin), tick));
    }

    @Override
    public void close() {
        this.thread.interrupt();
        this.thread.getSender().close();
        HandlerList.unregisterAll((Listener)this);
    }

    @NotNull
    public BukkitScoreboardSender getSender() {
        return this.thread.getSender();
    }

    @EventHandler
    public void handle(PlayerQuitEvent event) {
        this.getSender().onQuit(event.getPlayer());
    }

    @EventHandler
    public void handle(PluginDisableEvent event) {
        this.close();
    }

    public void setup() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.thread.start();
    }

    @NotNull
    public BukkitScoreboardThread getThread() {
        return this.thread;
    }

    private BukkitScoreboard(@NotNull Plugin plugin, @NotNull BukkitScoreboardThread thread) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (thread == null) {
            throw new NullPointerException("thread is marked non-null but is null");
        }
        this.plugin = plugin;
        this.thread = thread;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }
}

