/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.smartinventory.icon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Handle;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.event.abs.IconEvent;

public final class BasicIcon
implements Icon {
    private final Collection<Handle<? extends IconEvent>> handles = new ArrayList<Handle<? extends IconEvent>>();
    @NotNull
    private Predicate<InventoryContents> canSee = contents -> true;
    @NotNull
    private Predicate<InventoryContents> canUse = contents -> true;
    @NotNull
    private ItemStack fallback = new ItemStack(Material.AIR);
    @NotNull
    private ItemStack item;

    @Override
    public <T extends IconEvent> void accept(@NotNull T event) {
        InventoryContents contents = event.contents();
        if (this.canSee.test(contents) && this.canUse.test(contents)) {
            for (Handle<? extends IconEvent> target : this.handles) {
                if (!target.type().isAssignableFrom(event.getClass())) continue;
                target.accept(event);
            }
        }
    }

    @Override
    @NotNull
    public ItemStack calculateItem(@NotNull InventoryContents contents) {
        ItemStack calculated = this.canSee.test(contents) ? this.getItem() : this.fallback;
        return calculated;
    }

    @Override
    @NotNull
    public Icon canSee(@NotNull Predicate<InventoryContents> predicate) {
        this.canSee = predicate;
        return this;
    }

    @Override
    @NotNull
    public Icon canUse(@NotNull Predicate<InventoryContents> predicate) {
        this.canUse = predicate;
        return this;
    }

    @Override
    @NotNull
    public Icon fallback(@NotNull ItemStack fallback) {
        this.fallback = fallback;
        return this;
    }

    @Override
    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    @NotNull
    public <T extends IconEvent> Icon handle(@NotNull Handle<T> handle) {
        this.handles.add(handle);
        return this;
    }

    @Override
    @NotNull
    public Icon handles(@NotNull Collection<Handle<? extends IconEvent>> handles) {
        this.handles.addAll(handles);
        return this;
    }

    @Override
    @NotNull
    public Icon item(@NotNull ItemStack item) {
        this.item = item;
        return this;
    }

    public BasicIcon(@NotNull ItemStack item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.item = item;
    }
}

