/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.hooks.hooks.pl3xmap;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import net.pl3x.map.api.Key;
import net.pl3x.map.api.MapWorld;
import net.pl3x.map.api.Point;
import net.pl3x.map.api.SimpleLayerProvider;
import net.pl3x.map.api.marker.Marker;
import net.pl3x.map.api.marker.MarkerOptions;
import net.pl3x.map.api.marker.Rectangle;
import org.bukkit.ChatColor;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.pl3xmap.Claim;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.pl3xmap.MapConfig;
import tr.com.infumia.infumialib.platform.paper.utils.Colors;

public final class MapTask
extends BukkitRunnable {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    @NotNull
    private final MapConfig config;
    @NotNull
    private final Key key;
    @NotNull
    private final SimpleLayerProvider provider;
    private final AtomicBoolean stop = new AtomicBoolean(false);
    @NotNull
    private final MapWorld world;

    public synchronized void cancel() throws IllegalStateException {
        this.stop.set(true);
        this.provider.clearMarkers();
        this.world.layerRegistry().unregister(this.key);
        super.cancel();
    }

    public void handleClaim(@NotNull Claim claim) {
        this.handleClaim(claim, false);
    }

    public void handleClaim(@NotNull Claim claim, boolean child) {
        List list;
        Rectangle rect = Marker.rectangle((Point)Point.of((double)claim.getMinX(), (double)claim.getMinZ()), (Point)Point.of((double)claim.getMaxX(), (double)claim.getMaxZ()));
        if (child) {
            Map.Entry[] entryArray = new Map.Entry[9];
            entryArray[0] = Map.entry("<b>", () -> "<span style=\"font-weight:bold;\">");
            entryArray[1] = Map.entry("</b>", () -> "</span>");
            entryArray[2] = Map.entry("%owner%", claim::getOwner);
            entryArray[3] = Map.entry("%members%", () -> {
                StringJoiner joiner = new StringJoiner(",");
                for (Claim.Member member : claim.getMembers()) {
                    joiner.add(member.getName());
                }
                return joiner.toString();
            });
            entryArray[4] = Map.entry("%member_count%", () -> claim.getMembers().size());
            entryArray[5] = Map.entry("%remaining_time%", () -> DATE_FORMAT.format(new Date(claim.getRemainingTime())));
            entryArray[6] = Map.entry("%creation_time%", () -> DATE_FORMAT.format(new Date(claim.getCreationTime())));
            entryArray[7] = Map.entry("%sub_claim_count%", claim.getChildren()::size);
            entryArray[8] = Map.entry("%pvp%", () -> claim.isPvp() ? ChatColor.stripColor((String)this.config.getEnabledText()) : ChatColor.stripColor((String)this.config.getDisabledText()));
            list = (List)this.config.getChildClickTooltip().build(entryArray);
        } else {
            Map.Entry[] entryArray = new Map.Entry[9];
            entryArray[0] = Map.entry("<b>", () -> "<span style=\"font-weight:bold;\">");
            entryArray[1] = Map.entry("</b>", () -> "</span>");
            entryArray[2] = Map.entry("%owner%", claim::getOwner);
            entryArray[3] = Map.entry("%members%", () -> {
                StringJoiner joiner = new StringJoiner(",");
                for (Claim.Member member : claim.getMembers()) {
                    joiner.add(member.getName());
                }
                return joiner.toString();
            });
            entryArray[4] = Map.entry("%member_count%", () -> claim.getMembers().size());
            entryArray[5] = Map.entry("%remaining_time%", () -> DATE_FORMAT.format(new Date(claim.getRemainingTime())));
            entryArray[6] = Map.entry("%creation_time%", () -> DATE_FORMAT.format(new Date(claim.getCreationTime())));
            entryArray[7] = Map.entry("%sub_claim_count%", claim.getChildren()::size);
            entryArray[8] = Map.entry("%pvp%", () -> claim.isPvp() ? ChatColor.stripColor((String)this.config.getEnabledText()) : ChatColor.stripColor((String)this.config.getDisabledText()));
            list = (List)this.config.getClickTooltip().build(entryArray);
        }
        List build = list;
        Colors stroke = Colors.valueOf(child ? this.config.getChildStrokeColor() : this.config.getStrokeColor());
        Colors fill = Colors.valueOf(child ? this.config.getChildFillColor() : this.config.getFillColor());
        Color strokeColor = new Color((float)stroke.getRed(), (float)stroke.getGreen(), (float)stroke.getBlue());
        Color fillColor = new Color((float)fill.getRed(), (float)fill.getGreen(), (float)fill.getBlue());
        MarkerOptions.Builder options = MarkerOptions.builder().strokeColor(strokeColor).strokeWeight(child ? this.config.getChildStrokeWeight() : this.config.getStrokeWeight()).strokeOpacity(child ? this.config.getChildStrokeOpacity() : this.config.getStrokeOpacity()).fillColor(fillColor).fillOpacity(child ? this.config.getChildFillOpacity() : this.config.getFillOpacity()).clickTooltip(String.join((CharSequence)"<br/>", build));
        rect.markerOptions(options.build());
        String markerId = this.config.getRegionKeyPattern().replace("%world_unique_id%", this.world.uuid().toString()).replace("%world_name%", this.world.name()).replace("%claim_name%", claim.getName()).replace("%claim_id%", claim.getId().toString());
        this.provider.addMarker(Key.of((String)markerId), (Marker)rect);
    }

    public void removeMarker(@NotNull Claim claim) {
        String markerId = this.config.getRegionKeyPattern().replace("%world_unique_id%", this.world.uuid().toString()).replace("%world_name%", this.world.name()).replace("%claim_name%", claim.getName()).replace("%claim_id%", claim.getId().toString());
        this.provider.removeMarker(Key.key((String)markerId));
    }

    public void run() {
        if (!this.stop.get()) {
            this.updateClaims();
        }
    }

    private void updateClaims() {
        this.provider.clearMarkers();
        Collection<Claim> claims = this.config.getClaimSupplier().get();
        for (Claim claim : claims) {
            if (!claim.getChunk().getWorld().getUID().equals(this.world.uuid())) continue;
            this.handleClaim(claim);
            for (Claim child : claim.getChildren()) {
                this.handleClaim(child, true);
            }
        }
    }

    public MapTask(@NotNull MapConfig config, @NotNull Key key, @NotNull SimpleLayerProvider provider, @NotNull MapWorld world) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.config = config;
        this.key = key;
        this.provider = provider;
        this.world = world;
    }
}

