/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element.types;

import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.util.SlotPos;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class PtInsert
implements PlaceType {
    private final int column;
    private final int row;

    public PtInsert(int row, int column) {
        this.row = row;
        this.column = column;
    }

    @NotNull
    private static PtInsert create(@NotNull Map<String, Object> objects) {
        return new PtInsert(PlaceType.getInteger(objects, "row", 0), PlaceType.getInteger(objects, "column", 0));
    }

    @Override
    @NotNull
    public String getType() {
        return "insert";
    }

    @Override
    public void place(@NotNull Icon icon, @NotNull InventoryContents contents) {
        contents.set(SlotPos.of(this.row, this.column), icon);
    }

    @Override
    public void serialize(@NotNull TransformedData transformedData) {
        PlaceType.super.serialize(transformedData);
        TransformedData copy = transformedData.copy();
        copy.add("row", this.row, Integer.TYPE);
        copy.add("column", this.column, Integer.TYPE);
        transformedData.add("values", copy);
    }

    public static final class Deserializer
    implements PlaceType.Deserializer {
        public static final Deserializer INSTANCE = new Deserializer();

        @Override
        @NotNull
        public Optional<PlaceType> deserialize(@NotNull TransformedData transformedData) {
            return transformedData.getAsMap("values", String.class, Object.class).map(PtInsert::create);
        }
    }
}

