/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element.types;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.platform.paper.smartinventory.util.Pattern;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class PtFillRepeatingPattern
implements PlaceType {
    @NotNull
    private final List<String> pattern;
    private final boolean wrapAround;

    public PtFillRepeatingPattern(boolean wrapAround, @NotNull List<String> pattern) {
        this.wrapAround = wrapAround;
        this.pattern = Collections.unmodifiableList(pattern);
    }

    @NotNull
    private static PtFillRepeatingPattern create(@NotNull Map<String, Object> objects) {
        return new PtFillRepeatingPattern(PlaceType.getBoolean(objects, "wrap-around", false), PlaceType.getStringList(objects, "pattern", List.of("xxx", "yyy", "zzz")));
    }

    @Override
    @NotNull
    public String getType() {
        return "fill-repeating-pattern";
    }

    @Override
    public void place(@NotNull Icon icon, @NotNull InventoryContents contents) {
        contents.fillPatternRepeating(new Pattern<Icon>(this.wrapAround, (String[])this.pattern.toArray(String[]::new)));
    }

    @Override
    public void serialize(@NotNull TransformedData transformedData) {
        PlaceType.super.serialize(transformedData);
        TransformedData copy = transformedData.copy();
        copy.add("wrap-around", this.wrapAround, Boolean.TYPE);
        copy.addAsCollection("pattern", this.pattern, String.class);
        transformedData.add("values", copy);
    }

    public static final class Deserializer
    implements PlaceType.Deserializer {
        public static final Deserializer INSTANCE = new Deserializer();

        @Override
        @NotNull
        public Optional<PlaceType> deserialize(@NotNull TransformedData transformedData) {
            return transformedData.getAsMap("values", String.class, Object.class).map(PtFillRepeatingPattern::create);
        }
    }
}

