/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class ItemStackBuilder
extends Builder<ItemStackBuilder, ItemMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    private ItemStackBuilder(@NotNull ItemStack itemStack) {
        super(Objects.requireNonNull(itemStack.getItemMeta(), String.format("ItemMeta of %s couldn't get!", itemStack)), itemStack);
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull XMaterial material) {
        Material parsed = material.parseMaterial();
        if (parsed == null) {
            throw new IllegalStateException(String.format("Material from the %s cannot be null!", material.name()));
        }
        return ItemStackBuilder.from(parsed);
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull Material material) {
        return ItemStackBuilder.from(new ItemStack(material));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull ItemStack itemStack) {
        return new ItemStackBuilder(itemStack);
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull String nbtJson) {
        return ItemStackBuilder.from(NBTEditor.getItemFromTag((NBTEditor.NBTCompound)NBTEditor.getNBTCompound((String)nbtJson)));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull TransformedData data) {
        return ItemStackBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    @NotNull
    public ItemStackBuilder getSelf() {
        return this;
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<ItemStackBuilder>> {
        @Override
        @NotNull
        public Optional<ItemStackBuilder> apply(@NotNull TransformedData data) {
            return Builder.getItemStackDeserializer().apply(data).map(ItemStackBuilder::from).map(Builder::getItemMetaDeserializer).map(deserializer -> (ItemStackBuilder)deserializer.apply(data));
        }
    }
}

