/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.declarations;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.reflection.RefField;
import tr.com.infumia.infumialib.transformer.TransformedObject;
import tr.com.infumia.infumialib.transformer.annotations.Comment;
import tr.com.infumia.infumialib.transformer.annotations.Migration;
import tr.com.infumia.infumialib.transformer.annotations.Names;
import tr.com.infumia.infumialib.transformer.annotations.Variable;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.exceptions.TransformException;

public final class FieldDeclaration {
    @Nullable
    private final Comment comment;
    @NotNull
    private final RefField field;
    @NotNull
    private final GenericDeclaration genericDeclaration;
    @Nullable
    private final Migration migration;
    @Nullable
    private final TransformedObject object;
    @NotNull
    private final String path;
    @Nullable
    private final Variable variable;
    private boolean hideVariable;
    @Nullable
    private Object startingValue;

    private FieldDeclaration(@Nullable Comment comment, @NotNull RefField field, @NotNull GenericDeclaration genericDeclaration, @Nullable Migration migration, @Nullable TransformedObject object, @NotNull String path, @Nullable Variable variable, @Nullable Object startingValue) {
        this.comment = comment;
        this.field = field;
        this.genericDeclaration = genericDeclaration;
        this.migration = migration;
        this.object = object;
        this.path = path;
        this.variable = variable;
        this.startingValue = startingValue;
    }

    @NotNull
    public static FieldDeclaration of(@Nullable Names parent, @Nullable TransformedObject object, @NotNull RefField field) {
        return new FieldDeclaration(field.getAnnotation(Comment.class).orElse(null), field, GenericDeclaration.of(field), field.getAnnotation(Migration.class).orElse(null), object, Names.Calculated.calculatePath(parent, field), field.getAnnotation(Variable.class).orElse(null), Optional.ofNullable(object).flatMap(o -> field.of(o).getValue()).orElse(null));
    }

    @Nullable
    public Object getValue() throws TransformException {
        if (this.hideVariable) {
            return this.startingValue;
        }
        try {
            return this.field.of(this.object).getValue().orElseThrow();
        }
        catch (Exception exception) {
            throw new TransformException("Failed to use #getValue", exception);
        }
    }

    public void setValue(@Nullable Object value) {
        this.field.of(this.object).setValue(value);
    }

    public boolean isMigrated(@NotNull TransformedObjectDeclaration declaration) {
        return this.isMigrated(declaration.getVersionInteger());
    }

    public boolean isMigrated(int version) {
        return this.migration != null && version >= this.migration.value();
    }

    public boolean isNotMigrated(@NotNull TransformedObjectDeclaration declaration) {
        return !this.isMigrated(declaration);
    }

    public boolean isNotMigrated(int version) {
        return !this.isMigrated(version);
    }

    @Nullable
    public Comment getComment() {
        return this.comment;
    }

    @NotNull
    public RefField getField() {
        return this.field;
    }

    @NotNull
    public GenericDeclaration getGenericDeclaration() {
        return this.genericDeclaration;
    }

    @Nullable
    public Migration getMigration() {
        return this.migration;
    }

    @Nullable
    public TransformedObject getObject() {
        return this.object;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public Variable getVariable() {
        return this.variable;
    }

    public boolean isHideVariable() {
        return this.hideVariable;
    }

    @Nullable
    public Object getStartingValue() {
        return this.startingValue;
    }

    public String toString() {
        return "FieldDeclaration(comment=" + this.getComment() + ", field=" + this.getField() + ", genericDeclaration=" + this.getGenericDeclaration() + ", migration=" + this.getMigration() + ", object=" + this.getObject() + ", path=" + this.getPath() + ", variable=" + this.getVariable() + ", hideVariable=" + this.isHideVariable() + ", startingValue=" + this.getStartingValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldDeclaration)) {
            return false;
        }
        FieldDeclaration other = (FieldDeclaration)o;
        if (this.isHideVariable() != other.isHideVariable()) {
            return false;
        }
        Comment this$comment = this.getComment();
        Comment other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        RefField this$field = this.getField();
        RefField other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        GenericDeclaration this$genericDeclaration = this.getGenericDeclaration();
        GenericDeclaration other$genericDeclaration = other.getGenericDeclaration();
        if (this$genericDeclaration == null ? other$genericDeclaration != null : !((Object)this$genericDeclaration).equals(other$genericDeclaration)) {
            return false;
        }
        Migration this$migration = this.getMigration();
        Migration other$migration = other.getMigration();
        if (this$migration == null ? other$migration != null : !this$migration.equals(other$migration)) {
            return false;
        }
        TransformedObject this$object = this.getObject();
        TransformedObject other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Variable this$variable = this.getVariable();
        Variable other$variable = other.getVariable();
        if (this$variable == null ? other$variable != null : !this$variable.equals(other$variable)) {
            return false;
        }
        Object this$startingValue = this.getStartingValue();
        Object other$startingValue = other.getStartingValue();
        return !(this$startingValue == null ? other$startingValue != null : !this$startingValue.equals(other$startingValue));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHideVariable() ? 79 : 97);
        Comment $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        RefField $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        GenericDeclaration $genericDeclaration = this.getGenericDeclaration();
        result = result * 59 + ($genericDeclaration == null ? 43 : ((Object)$genericDeclaration).hashCode());
        Migration $migration = this.getMigration();
        result = result * 59 + ($migration == null ? 43 : $migration.hashCode());
        TransformedObject $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Variable $variable = this.getVariable();
        result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
        Object $startingValue = this.getStartingValue();
        result = result * 59 + ($startingValue == null ? 43 : $startingValue.hashCode());
        return result;
    }

    public void setHideVariable(boolean hideVariable) {
        this.hideVariable = hideVariable;
    }

    public void setStartingValue(@Nullable Object startingValue) {
        this.startingValue = startingValue;
    }
}

