/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.shared;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Kubernetes {
    @Nullable
    private static KubernetesClient client;
    @Nullable
    private static RedisClient redisClient;

    private Kubernetes() {
    }

    public static void initClient() {
        client = new DefaultKubernetesClient();
    }

    public static void initRedis(@NotNull String masterName, @NotNull String password) {
        ServiceSpec sentinel = ((Service)((ServiceResource)((NonNamespaceOperation)Kubernetes.kubernetesClient().services().inNamespace("redis")).withName("sentinel")).get()).getSpec();
        String ip = sentinel.getClusterIP();
        Integer port = sentinel.getPorts().stream().findFirst().map(ServicePort::getPort).orElseThrow();
        redisClient = RedisClient.create((RedisURI)RedisURI.Builder.sentinel((String)ip, (int)port, (String)masterName).withPassword(password.toCharArray()).build());
    }

    public static void initRedis(@NotNull String password) {
        Kubernetes.initRedis("mymaster", password);
    }

    public static void initRedis() {
        Kubernetes.initRedis("password");
    }

    @NotNull
    public static KubernetesClient kubernetesClient() {
        if (client == null) {
            Kubernetes.initClient();
        }
        return client;
    }

    @NotNull
    public static RedisClient redisClient() {
        return Objects.requireNonNull(redisClient, "redis client");
    }
}

