/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.reflection;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.reflection.RefAnnotated;
import tr.com.infumia.infumialib.reflection.RefConstructed;
import tr.com.infumia.infumialib.reflection.RefField;
import tr.com.infumia.infumialib.reflection.RefMethod;
import tr.com.infumia.infumialib.reflection.RefModifiable;

public interface RefClass<T>
extends RefAnnotated,
RefModifiable {
    @NotNull
    public Optional<RefConstructed<T>> getConstructor(Object ... var1);

    @NotNull
    public Optional<RefConstructed<T>> getConstructor(int var1);

    @NotNull
    public List<RefField> getDeclaredFields();

    @NotNull
    default public <A extends Annotation> List<RefField> getDeclaredFieldsWithAnnotation(@NotNull Class<A> annotationClass) {
        ArrayList<RefField> list = new ArrayList<RefField>();
        for (RefField refField : this.getDeclaredFields()) {
            if (!refField.hasAnnotation(annotationClass)) continue;
            list.add(refField);
        }
        return list;
    }

    default public <A extends Annotation> void getDeclaredFieldsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefField, A> consumer) {
        this.getDeclaredFields().forEach(refField -> refField.getAnnotation(annotationClass, a -> consumer.accept((RefField)refField, (Object)a)));
    }

    @NotNull
    public List<RefMethod> getDeclaredMethods();

    @NotNull
    default public <A extends Annotation> List<RefMethod> getDeclaredMethodsWithAnnotation(@NotNull Class<A> annotationClass) {
        ArrayList<RefMethod> list = new ArrayList<RefMethod>();
        for (RefMethod refMethod : this.getDeclaredMethods()) {
            if (!refMethod.hasAnnotation(annotationClass)) continue;
            list.add(refMethod);
        }
        return list;
    }

    default public <A extends Annotation> void getDeclaredMethodsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefMethod, A> consumer) {
        this.getDeclaredMethods().forEach(refField -> refField.getAnnotation(annotationClass, a -> consumer.accept((RefMethod)refField, (Object)a)));
    }

    @NotNull
    public Optional<RefField> getField(@NotNull String var1);

    @NotNull
    public <X> Optional<RefField> getField(@NotNull RefClass<X> var1);

    @NotNull
    public Optional<RefField> getField(@NotNull Class<?> var1);

    @NotNull
    public List<RefField> getFields();

    @NotNull
    default public <A extends Annotation> List<RefField> getFieldsWithAnnotation(@NotNull Class<A> annotationClass) {
        ArrayList<RefField> list = new ArrayList<RefField>();
        for (RefField refField : this.getFields()) {
            if (!refField.hasAnnotation(annotationClass)) continue;
            list.add(refField);
        }
        return list;
    }

    default public <A extends Annotation> void getFieldsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefField, A> consumer) {
        for (RefField refField : this.getFields()) {
            refField.getAnnotation(annotationClass, a -> consumer.accept(refField, a));
        }
    }

    @NotNull
    public Optional<RefMethod> getMethod(@NotNull String var1, Object ... var2);

    @NotNull
    public Optional<RefMethod> getMethodByName(String ... var1);

    @NotNull
    public Optional<RefMethod> getMethodByParameter(Object ... var1);

    @NotNull
    public <X> Optional<RefMethod> getMethodByReturnType(@NotNull RefClass<X> var1);

    @NotNull
    public Optional<RefMethod> getMethodByReturnType(@NotNull Class<?> var1);

    @NotNull
    public List<RefMethod> getMethods();

    @NotNull
    default public <A extends Annotation> List<RefMethod> getMethodsWithAnnotation(@NotNull Class<A> annotationClass) {
        ArrayList<RefMethod> list = new ArrayList<RefMethod>();
        for (RefMethod refField : this.getMethods()) {
            if (!refField.hasAnnotation(annotationClass)) continue;
            list.add(refField);
        }
        return list;
    }

    default public <A extends Annotation> void getMethodsWithAnnotation(@NotNull Class<A> annotationClass, @NotNull BiConsumer<RefMethod, A> consumer) {
        for (RefMethod refField : this.getMethods()) {
            refField.getAnnotation(annotationClass, a -> consumer.accept(refField, a));
        }
    }

    @NotNull
    public Optional<RefConstructed<T>> getPrimitiveConstructor(Object ... var1);

    @NotNull
    public Optional<RefMethod> getPrimitiveMethod(@NotNull String var1, Object ... var2);

    @NotNull
    public Optional<RefMethod> getPrimitiveMethodByParameter(Object ... var1);

    @NotNull
    public Class<T> getRealClass();

    public boolean isInstance(@NotNull Object var1);
}

