/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper;

import cloud.commandframework.paper.PaperCommandManager;
import com.github.yannicklamprecht.worldborder.api.BorderAPI;
import com.github.yannicklamprecht.worldborder.api.WorldBorderApi;
import java.nio.file.Path;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.files.InfumiaLibConfig;
import tr.com.infumia.infumialib.kubernetes.Kubernetes;
import tr.com.infumia.infumialib.messaging.messengers.ServerMessenger;
import tr.com.infumia.infumialib.platform.paper.InfumiaLib;
import tr.com.infumia.infumialib.platform.paper.Metrics;
import tr.com.infumia.infumialib.platform.paper.border.Border;
import tr.com.infumia.infumialib.platform.paper.border.PersistenceWrapper;
import tr.com.infumia.infumialib.platform.paper.color.CustomColors;
import tr.com.infumia.infumialib.platform.paper.commands.InfumiaPluginCommands;
import tr.com.infumia.infumialib.platform.paper.files.PaperConfig;
import tr.com.infumia.infumialib.platform.paper.hooks.Hooks;
import tr.com.infumia.infumialib.platform.paper.messaging.BukkitTravel;
import tr.com.infumia.infumialib.platform.paper.utils.TaskUtilities;
import tr.com.infumia.infumialib.util.GitHubUpdateChecker;

final class Initializer {
    static void enable(@NotNull InfumiaLib plugin) {
        Hooks.loadHooks();
        Initializer.initiateWorldBorder(plugin);
        PaperCommandManager<CommandSender> commandManager = InfumiaLib.createCommandManager((Plugin)plugin);
        new InfumiaPluginCommands(commandManager, plugin).register();
        InfumiaLib.getInventory().init();
        if (InfumiaLibConfig.checkForUpdate) {
            PluginDescriptionFile description = plugin.getDescription();
            GitHubUpdateChecker.checkForUpdate((Audience)Bukkit.getConsoleSender(), plugin.getSLF4JLogger(), description.getVersion(), description.getName(), "Infumia", "InfumiaLib");
        }
        new Metrics((Plugin)plugin, 11422);
        if (PaperConfig.multiServer) {
            Kubernetes.initClient();
            Kubernetes.initRedis(PaperConfig.redisPassword);
            new BukkitTravel((Plugin)plugin, new ServerMessenger(PaperConfig.serverGroup));
        }
    }

    static void load(@NotNull InfumiaLib plugin) {
        CustomColors.registerAll();
        TaskUtilities.init((Plugin)plugin);
        Path path = plugin.getDataFolder().toPath();
        InfumiaLibConfig.loadConfig(path.resolve("config.yml"));
        PaperConfig.loadConfig(path.resolve("paper.yml"));
    }

    private static void initiateWorldBorder(@NotNull InfumiaLib plugin) {
        try {
            PersistenceWrapper worldBorderApi = new PersistenceWrapper(plugin, (WorldBorderApi)new Border());
            plugin.getServer().getServicesManager().register(WorldBorderApi.class, (Object)worldBorderApi, (Plugin)plugin, ServicePriority.High);
            BorderAPI.setWorldBorderApi((WorldBorderApi)worldBorderApi);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Initializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

