/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.scoreboard.line;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.scoreboard.line.Line;
import tr.com.infumia.infumialib.scoreboard.line.LineColor;
import tr.com.infumia.infumialib.scoreboard.line.lines.FramedLine;
import tr.com.infumia.infumialib.scoreboard.line.lines.HighlightedLine;
import tr.com.infumia.infumialib.scoreboard.line.lines.ScrolledLine;

public interface AnimatedLine<O>
extends Line<O> {
    @NotNull
    public static <O> AnimatedLine<O> framed(String ... frames) {
        return AnimatedLine.framed(false, frames);
    }

    @NotNull
    public static <O> AnimatedLine<O> framed(boolean update, String ... frames) {
        return AnimatedLine.framed(List.of(frames), update);
    }

    @NotNull
    public static <O> AnimatedLine<O> framed(@NotNull List<String> frames) {
        return AnimatedLine.framed(frames, false);
    }

    @NotNull
    public static <O> AnimatedLine<O> framed(@NotNull List<String> frames, boolean update) {
        return new Framed(frames, update);
    }

    @NotNull
    public static <O> AnimatedLine<O> highlighted(@NotNull String context, @NotNull String highlightFormat, @NotNull String normalFormat) {
        return AnimatedLine.highlighted(context, highlightFormat, normalFormat, "", "");
    }

    @NotNull
    public static <O> AnimatedLine<O> highlighted(@NotNull String context, @NotNull String highlightFormat, @NotNull String normalFormat, boolean update) {
        return AnimatedLine.highlighted(context, highlightFormat, normalFormat, "", "", update);
    }

    @NotNull
    public static <O> AnimatedLine<O> highlighted(@NotNull String context, @NotNull String highlightFormat, @NotNull String normalFormat, @NotNull String prefix, @NotNull String suffix) {
        return AnimatedLine.highlighted(context, highlightFormat, normalFormat, prefix, suffix, false);
    }

    @NotNull
    public static <O> AnimatedLine<O> highlighted(@NotNull String context, @NotNull String highlightFormat, @NotNull String normalFormat, @NotNull String prefix, @NotNull String suffix, boolean update) {
        return new Highlighted(context, highlightFormat, normalFormat, prefix, suffix, update);
    }

    @NotNull
    public static <O> AnimatedLine<O> scrolled(@NotNull String message, int spaceBetween, int width, @NotNull LineColor color) {
        return AnimatedLine.scrolled(message, spaceBetween, width, color, false);
    }

    @NotNull
    public static <O> AnimatedLine<O> scrolled(@NotNull String message, int spaceBetween, int width, @NotNull LineColor color, boolean update) {
        return new Scrolled(message, spaceBetween, width, color, update);
    }

    default public boolean animate() {
        return true;
    }

    @Override
    @NotNull
    default public String apply(@NotNull O o) {
        if (!this.animate()) {
            return Objects.requireNonNullElse(this.getCurrent(o), "");
        }
        if (this.forward()) {
            return this.getNext(o);
        }
        return this.getPrevious(o);
    }

    default public boolean forward() {
        return true;
    }

    @Nullable
    public String getCurrent(@NotNull O var1);

    @NotNull
    public String getNext(@NotNull O var1);

    @NotNull
    public String getPrevious(@NotNull O var1);

    public static final class Framed<O>
    extends FramedLine<O> {
        private final boolean update;

        private Framed(@NotNull List<String> frames, boolean update) {
            super(new ArrayList<String>(frames));
            this.update = update;
        }

        @Override
        public boolean isUpdate() {
            return this.update;
        }
    }

    public static final class Highlighted<O>
    extends HighlightedLine<O> {
        private final boolean update;

        private Highlighted(@NotNull String context, @NotNull String highlightFormat, @NotNull String normalFormat, @NotNull String prefix, @NotNull String suffix, boolean update) {
            super(context, highlightFormat, normalFormat, prefix, suffix);
            this.update = update;
            this.generate();
        }

        @Override
        public boolean isUpdate() {
            return this.update;
        }
    }

    public static final class Scrolled<O>
    extends ScrolledLine<O> {
        private final boolean update;

        private Scrolled(@NotNull String message, int spaceBetween, int width, @NotNull LineColor color, boolean update) {
            super(message, spaceBetween, width, color);
            this.update = update;
            this.generate();
        }

        @Override
        public boolean isUpdate() {
            return this.update;
        }
    }
}

