/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.versionmatched;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.version.BukkitVersion;
import tr.com.infumia.infumialib.platform.paper.versionmatched.VersionClass;
import tr.com.infumia.infumialib.reflection.RefConstructed;
import tr.com.infumia.infumialib.reflection.clazz.ClassOf;

public final class VersionMatched<T> {
    @NotNull
    private final BukkitVersion version;
    @NotNull
    private final Collection<VersionClass<T>> versionClasses;

    public VersionMatched(@NotNull String version, @NotNull Collection<VersionClass<T>> versionClasses) {
        this(new BukkitVersion(version), versionClasses);
    }

    @SafeVarargs
    public VersionMatched(@NotNull String version, Class<? extends T> ... versionClasses) {
        this(version, (Collection)Arrays.stream(versionClasses).map(VersionClass::new).collect(Collectors.toList()));
    }

    @SafeVarargs
    public VersionMatched(Class<? extends T> ... versionClasses) {
        this(new BukkitVersion(), (Collection)Arrays.stream(versionClasses).map(VersionClass::new).collect(Collectors.toList()));
    }

    @NotNull
    public RefConstructed<T> of(Object ... types) {
        Class match = this.match();
        return new ClassOf<T>(match).getConstructor(types).orElseThrow(() -> new IllegalStateException(String.format("match() -> Couldn't find any constructor on \"%s\" version!", match.getSimpleName())));
    }

    @NotNull
    public RefConstructed<T> ofPrimitive(Object ... types) {
        Class match = this.match();
        return new ClassOf<T>(match).getPrimitiveConstructor(types).orElseThrow(() -> new IllegalStateException(String.format("match() -> Couldn't find any constructor on \"%s\" version!", match.getSimpleName())));
    }

    @NotNull
    private Class<? extends T> match() {
        for (VersionClass<T> versionClass : this.versionClasses) {
            if (!versionClass.match(this.version)) continue;
            return versionClass.getVersionClass();
        }
        throw new IllegalStateException(String.format("match() -> Couldn't find any matched class on \"%s\" version!", this.version.getVersion()));
    }

    public VersionMatched(@NotNull BukkitVersion version, @NotNull Collection<VersionClass<T>> versionClasses) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (versionClasses == null) {
            throw new NullPointerException("versionClasses is marked non-null but is null");
        }
        this.version = version;
        this.versionClasses = versionClasses;
    }
}

