/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element.types;

import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class PtFillSquareIndex
implements PlaceType {
    private final int fromIndex;
    private final int toIndex;

    @NotNull
    private static PtFillSquareIndex create(@NotNull Map<String, Object> objects) {
        return new PtFillSquareIndex(PlaceType.getInteger(objects, "from-index", 0), PlaceType.getInteger(objects, "to-index", 0));
    }

    @Override
    @NotNull
    public String getType() {
        return "fill-square-index";
    }

    @Override
    public void place(@NotNull Icon icon, @NotNull InventoryContents contents) {
        contents.fillSquare(this.fromIndex, this.toIndex, icon);
    }

    @Override
    public void serialize(@NotNull TransformedData transformedData) {
        PlaceType.super.serialize(transformedData);
        TransformedData copy = transformedData.copy();
        copy.add("from-index", this.fromIndex, Integer.TYPE);
        copy.add("to-index", this.toIndex, Integer.TYPE);
        transformedData.add("values", copy);
    }

    public PtFillSquareIndex(int fromIndex, int toIndex) {
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    public static final class Deserializer
    implements PlaceType.Deserializer {
        public static final Deserializer INSTANCE = new Deserializer();

        @Override
        @NotNull
        public Optional<PlaceType> deserialize(@NotNull TransformedData transformedData) {
            return transformedData.getAsMap("values", String.class, Object.class).map(PtFillSquareIndex::create);
        }
    }
}

