/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import com.cryptomorin.xseries.SkullUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.platform.paper.smartinventory.util.ReflectionUtils;
import tr.com.infumia.infumialib.reflection.RefConstructed;
import tr.com.infumia.infumialib.reflection.clazz.ClassOf;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class SkullItemBuilder
extends Builder<SkullItemBuilder, SkullMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    SkullItemBuilder(@NotNull SkullMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static SkullItemBuilder from(@NotNull SkullMeta itemMeta, @NotNull ItemStack itemStack) {
        return new SkullItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static SkullItemBuilder from(@NotNull TransformedData data) {
        return SkullItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    @NotNull
    public SkullItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        super.serialize(data);
        data.add("skull", SkullUtils.getSkinValue(this.getItemMeta()), String.class);
    }

    @NotNull
    public SkullItemBuilder removeOwner() {
        if (Builder.VERSION < 13) {
            ((SkullMeta)this.getItemMeta()).setOwner(null);
        } else {
            ((SkullMeta)this.getItemMeta()).setOwningPlayer(null);
        }
        return this.getSelf();
    }

    @NotNull
    public SkullItemBuilder setOwner(@NotNull String texture) {
        SkullUtils.applySkin(this.getItemMeta(), (String)texture);
        ClassOf<SkullMeta> cls = new ClassOf<SkullMeta>((SkullMeta)this.getItemMeta());
        Object profile = cls.getField("profile").flatMap(refField -> refField.of(this.getItemMeta()).getValue()).orElseThrow();
        Object nbt = new ClassOf(Objects.requireNonNull(ReflectionUtils.getNMSClass("NBTTagCompound"))).getConstructor(new Object[0]).flatMap(rec$ -> ((RefConstructed)rec$).create(new Object[0])).orElseThrow();
        Object serialized = new ClassOf(Objects.requireNonNull(ReflectionUtils.getNMSClass("GameProfileSerializer"))).getMethodByName("serialize").flatMap(refMethod -> refMethod.call(nbt, profile)).orElseThrow();
        cls.getField("serializedProfile").map(refField -> refField.of(this.getItemMeta())).ifPresent(refFieldExecuted -> refFieldExecuted.setValue(serialized));
        return this.getSelf();
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<SkullItemBuilder>> {
        @Override
        @NotNull
        public Optional<SkullItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            SkullItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asSkull();
            data.get("skull", String.class).ifPresent(builder::setOwner);
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

