/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import com.cryptomorin.xseries.XPotion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class PotionItemBuilder
extends Builder<PotionItemBuilder, PotionMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    PotionItemBuilder(@NotNull PotionMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static PotionItemBuilder from(@NotNull PotionMeta itemMeta, @NotNull ItemStack itemStack) {
        return new PotionItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static PotionItemBuilder from(@NotNull TransformedData data) {
        return PotionItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @NotNull
    public PotionItemBuilder addCustomEffect(@NotNull PotionEffect effect, boolean overwrite) {
        if (Builder.VERSION >= 9) {
            ((PotionMeta)this.getItemMeta()).addCustomEffect(effect, overwrite);
        }
        return this.getSelf();
    }

    @NotNull
    public PotionItemBuilder addCustomEffects(@NotNull Collection<String> effects, boolean overwrite) {
        if (Builder.VERSION >= 9) {
            for (String effect : effects) {
                PotionEffect potionEffect = XPotion.parsePotionEffectFromString((String)effect);
                if (potionEffect == null) continue;
                this.addCustomEffect(potionEffect, overwrite);
            }
        }
        return this.getSelf();
    }

    @NotNull
    public PotionItemBuilder clearCustomEffects() {
        ((PotionMeta)this.getItemMeta()).clearCustomEffects();
        return this.getSelf();
    }

    @Override
    @NotNull
    public PotionItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        super.serialize(data);
        ItemStack itemStack = this.getItemStack(false);
        PotionMeta itemMeta = (PotionMeta)this.getItemMeta();
        if (Builder.VERSION >= 9) {
            List customEffects = itemMeta.getCustomEffects();
            ArrayList<String> effects = new ArrayList<String>(customEffects.size());
            for (PotionEffect effect : customEffects) {
                effects.add(String.format("%s, %d, %d", effect.getType().getName(), effect.getDuration(), effect.getAmplifier()));
            }
            data.addAsCollection("custom-effects", effects, String.class);
            PotionData potionData = itemMeta.getBasePotionData();
            data.add("base-effect", String.format("%s, %s, %s", potionData.getType().name(), potionData.isExtended(), potionData.isUpgraded()), String.class);
            if (Builder.VERSION >= 11) {
                Color color = itemMeta.getColor();
                if (itemMeta.hasColor() && color != null) {
                    data.add("color", color.asRGB(), Integer.TYPE);
                }
            }
        } else if (itemStack.getDurability() != 0) {
            Potion potion = Potion.fromItemStack((ItemStack)itemStack);
            data.add("level", potion.getLevel(), Integer.TYPE);
            data.add("base-effect", String.format("%s, %s, %s", potion.getType().name(), potion.hasExtendedDuration(), potion.isSplash()), String.class);
        }
    }

    @NotNull
    public PotionItemBuilder removeCustomEffect(@NotNull PotionEffectType type) {
        ((PotionMeta)this.getItemMeta()).removeCustomEffect(type);
        return this.getSelf();
    }

    @NotNull
    public PotionItemBuilder setBasePotionData(@NotNull PotionData data) {
        if (Builder.VERSION >= 9) {
            ((PotionMeta)this.getItemMeta()).setBasePotionData(data);
        }
        return this.getSelf();
    }

    @NotNull
    public PotionItemBuilder setBasePotionData(@NotNull String data) {
        PotionType type;
        if (Builder.VERSION < 9) {
            return this.getSelf();
        }
        if (data.isEmpty()) {
            return this.getSelf();
        }
        String[] split = data.split(",");
        try {
            type = PotionType.valueOf((String)split[0].trim().toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            type = PotionType.UNCRAFTABLE;
        }
        boolean extended = split.length != 1 && Boolean.parseBoolean(split[1].trim());
        boolean upgraded = split.length > 2 && Boolean.parseBoolean(split[2].trim());
        PotionData potionData = new PotionData(type, extended, upgraded);
        return this.setBasePotionData(potionData);
    }

    @NotNull
    public PotionItemBuilder setBasePotionData(@NotNull String data, int level) {
        PotionType type;
        if (Builder.VERSION >= 9) {
            return this.setBasePotionData(data);
        }
        if (data.isEmpty()) {
            return this.getSelf();
        }
        String[] split = data.split(",");
        try {
            type = PotionType.valueOf((String)split[0].trim().toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            type = PotionType.SLOWNESS;
        }
        boolean extended = split.length != 1 && Boolean.parseBoolean(split[1].trim());
        boolean splash = split.length > 2 && Boolean.parseBoolean(split[2].trim());
        return (PotionItemBuilder)this.setItemStack(new Potion(type, level, splash, extended).toItemStack(1));
    }

    @NotNull
    public PotionItemBuilder setColor(@Nullable Color color) {
        if (Builder.VERSION >= 11) {
            ((PotionMeta)this.getItemMeta()).setColor(color);
        }
        return this.getSelf();
    }

    @NotNull
    public PotionItemBuilder setColor(int color) {
        return this.setColor(Color.fromRGB((int)color));
    }

    @Deprecated
    @NotNull
    public PotionItemBuilder setMainEffect(@NotNull PotionEffectType type) {
        ((PotionMeta)this.getItemMeta()).setMainEffect(type);
        return this.getSelf();
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<PotionItemBuilder>> {
        @Override
        @NotNull
        public Optional<PotionItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            PotionItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asPotion();
            Integer level = data.get("level", Integer.TYPE).orElse(1);
            Optional<String> baseEffect = data.get("base-effect", String.class);
            Optional<Integer> color = data.get("color", Integer.TYPE);
            List<String> customEffects = data.getAsCollection("custom-effects", String.class).orElse(Collections.emptyList());
            color.ifPresent(builder::setColor);
            builder.addCustomEffects(customEffects, true);
            baseEffect.ifPresent(s -> builder.setBasePotionData((String)s, level));
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

