/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.transformer.resolvers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.transformer.resolvers.BukkitResolverHelper;
import tr.com.infumia.infumialib.transformer.TransformResolver;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.TransformedObjectDeclaration;
import tr.com.infumia.infumialib.transformer.exceptions.TransformException;
import tr.com.infumia.infumialib.transformer.postprocessor.PostProcessor;

public final class BukkitGsonJson
extends TransformResolver {
    @NotNull
    private final Gson gson;
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    public BukkitGsonJson() {
        this(new GsonBuilder().setPrettyPrinting().create());
    }

    @Override
    @NotNull
    public List<String> allKeys() {
        return List.copyOf(this.map.keySet());
    }

    @Override
    @Nullable
    public <T> T deserialize(@Nullable Object object, @Nullable GenericDeclaration genericSource, @NotNull Class<T> targetClass, @Nullable GenericDeclaration genericTarget, @Nullable Object defaultValue) throws TransformException {
        if (object instanceof ConfigurationSection) {
            Map<String, Object> values = BukkitResolverHelper.getMapValues((ConfigurationSection)object, false);
            return super.deserialize(values, GenericDeclaration.of(values), targetClass, genericTarget, defaultValue);
        }
        return super.deserialize(object, genericSource, targetClass, genericTarget, defaultValue);
    }

    @Override
    @NotNull
    public Optional<Object> getValue(@NotNull String path) {
        return Optional.ofNullable(this.map.get(path));
    }

    @Override
    public void load(@NotNull InputStream inputStream, @NotNull TransformedObjectDeclaration declaration) {
        this.map = (Map)this.gson.fromJson(PostProcessor.of(inputStream).getContext(), Map.class);
        if (this.map == null) {
            this.map = new LinkedHashMap<String, Object>();
        }
    }

    @Override
    public boolean pathExists(@NotNull String path) {
        return this.map.containsKey(path);
    }

    @Override
    public void removeValue(@NotNull String path, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.remove(path);
    }

    @Override
    @Nullable
    public Object serialize(@Nullable Object value, @Nullable GenericDeclaration genericType, boolean conservative) throws TransformException {
        if (value instanceof ConfigurationSection) {
            return BukkitResolverHelper.getMapValues((ConfigurationSection)value, false);
        }
        return super.serialize(value, genericType, conservative);
    }

    @Override
    public void setValue(@NotNull String path, @Nullable Object value, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.put(path, this.serialize(value, genericType, true));
    }

    @Override
    public void write(@NotNull OutputStream outputStream, @NotNull TransformedObjectDeclaration declaration) {
        this.gson.toJson(this.map, (Appendable)new OutputStreamWriter(outputStream));
    }

    public BukkitGsonJson(@NotNull Gson gson) {
        if (gson == null) {
            throw new NullPointerException("gson is marked non-null but is null");
        }
        this.gson = gson;
    }
}

