/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element.types;

import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.InventoryContents;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class PtFillSquareFromTo
implements PlaceType {
    private final int fromColumn;
    private final int fromRow;
    private final int toColumn;
    private final int toRow;

    public PtFillSquareFromTo(int fromRow, int fromColumn, int toRow, int toColumn) {
        this.fromRow = fromRow;
        this.fromColumn = fromColumn;
        this.toRow = toRow;
        this.toColumn = toColumn;
    }

    @NotNull
    private static PtFillSquareFromTo create(@NotNull Map<String, Object> objects) {
        return new PtFillSquareFromTo(PlaceType.getInteger(objects, "from-row", 0), PlaceType.getInteger(objects, "from-column", 0), PlaceType.getInteger(objects, "to-row", 0), PlaceType.getInteger(objects, "to-column", 1));
    }

    @Override
    @NotNull
    public String getType() {
        return "fill-square-from-to";
    }

    @Override
    public void place(@NotNull Icon icon, @NotNull InventoryContents contents) {
        contents.fillSquare(this.fromRow, this.fromColumn, this.toRow, this.toColumn, icon);
    }

    @Override
    public void serialize(@NotNull TransformedData transformedData) {
        PlaceType.super.serialize(transformedData);
        TransformedData copy = transformedData.copy();
        copy.add("from-row", this.fromRow, Integer.TYPE);
        copy.add("from-column", this.fromColumn, Integer.TYPE);
        copy.add("to-row", this.toRow, Integer.TYPE);
        copy.add("to-column", this.toColumn, Integer.TYPE);
        transformedData.add("values", copy);
    }

    public static final class Deserializer
    implements PlaceType.Deserializer {
        public static final Deserializer INSTANCE = new Deserializer();

        @Override
        @NotNull
        public Optional<PlaceType> deserialize(@NotNull TransformedData transformedData) {
            return transformedData.getAsMap("values", String.class, Object.class).map(PtFillSquareFromTo::create);
        }
    }
}

