/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.transformer.Transformer;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericHolder;
import tr.com.infumia.infumialib.transformer.declarations.GenericPair;

public interface TwoSideTransformer<R, F>
extends Transformer<R, F> {
    @NotNull
    public static <R, F> TwoSideTransformer<R, F> create(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal) {
        return new Impl<R, F>(rawType, finalType, toRaw, toFinal);
    }

    @NotNull
    public static <R, F> TwoSideTransformer<R, F> create(@NotNull GenericDeclaration rawType, @NotNull GenericDeclaration finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal) {
        return new Impl<R, F>(rawType, finalType, toRaw, toFinal);
    }

    @NotNull
    public static <R, F> TwoSideTransformer<R, F> create(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> toFinalWithField) {
        return new Impl<R, F>(rawType, finalType, toRaw, toFinal, toFinalWithField);
    }

    @NotNull
    default public TwoSideTransformer<F, R> reverse() {
        return TwoSideTransformer.create(this.getRightType(), this.getLeftType(), this::toFinalOrNull, this::toRawOrNull);
    }

    @NotNull
    public Optional<F> toFinal(@NotNull R var1);

    @Nullable
    default public F toFinalOrNull(@NotNull R r) {
        return this.toFinal(r).orElse(null);
    }

    @NotNull
    public Optional<F> toFinalWithField(@NotNull R var1, @NotNull F var2);

    @Nullable
    default public F toFinalWithFieldOrNull(@NotNull R r, @NotNull F field) {
        return this.toFinalWithField(r, field).orElse(null);
    }

    @NotNull
    public Optional<R> toRaw(@NotNull F var1);

    @Nullable
    default public R toRawOrNull(@NotNull F f) {
        return this.toRaw(f).orElse(null);
    }

    @Override
    @NotNull
    default public Optional<F> transform(@NotNull R r) {
        return this.toFinal(r);
    }

    @Override
    @NotNull
    default public Optional<F> transformWithField(@NotNull R r, @NotNull F field) {
        return this.toFinalWithField(r, field);
    }

    public static final class Impl<R, F>
    extends Base<R, F> {
        private Impl(@NotNull GenericDeclaration rawType, @NotNull GenericDeclaration finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> toFinalWithField) {
            super(rawType, finalType, toRaw, toFinal, toFinalWithField);
        }

        private Impl(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> toFinalWithField) {
            this(GenericDeclaration.ofReady(rawType), GenericDeclaration.ofReady(finalType), toRaw, toFinal, toFinalWithField);
        }

        private Impl(@NotNull GenericDeclaration rawType, @NotNull GenericDeclaration finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal) {
            this(rawType, finalType, toRaw, toFinal, (R r, F field) -> toFinal.apply(r));
        }

        private Impl(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal) {
            this(GenericDeclaration.ofReady(rawType), GenericDeclaration.ofReady(finalType), toRaw, toFinal);
        }
    }

    public static abstract class Base<R, F>
    implements TwoSideTransformer<R, F> {
        @NotNull
        private final GenericHolder<R, F> holder;
        @NotNull
        private final @NotNull Function<@NotNull R, @Nullable F> toFinal;
        @NotNull
        private final @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> toFinalWithField;
        @NotNull
        private final @NotNull Function<@NotNull F, @Nullable R> toRaw;

        protected Base(@NotNull GenericHolder<R, F> holder, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> toFinalWithField) {
            this.holder = holder;
            this.toRaw = toRaw;
            this.toFinal = toFinal;
            this.toFinalWithField = toFinalWithField;
        }

        protected Base(@NotNull GenericDeclaration rawType, @NotNull GenericDeclaration finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> toFinalWithField) {
            this(GenericHolder.create(rawType, finalType), toRaw, toFinal, toFinalWithField);
        }

        protected Base(@NotNull GenericDeclaration rawType, @NotNull GenericDeclaration finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal) {
            this(GenericHolder.create(rawType, finalType), toRaw, toFinal, (R r, F field) -> toFinal.apply(r));
        }

        protected Base(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal) {
            this(GenericDeclaration.ofReady(rawType), GenericDeclaration.ofReady(finalType), toRaw, toFinal);
        }

        protected Base(@NotNull Class<R> rawType, @NotNull Class<F> finalType, @NotNull @NotNull Function<@NotNull F, @Nullable R> toRaw, @NotNull @NotNull Function<@NotNull R, @Nullable F> toFinal, @NotNull @NotNull BiFunction<@NotNull R, @NotNull F, @Nullable F> toFinalWithField) {
            this(GenericHolder.create(rawType, finalType), toRaw, toFinal, toFinalWithField);
        }

        @Override
        @NotNull
        public final Optional<F> toFinal(@NotNull R r) {
            return Optional.ofNullable(this.toFinal.apply(r));
        }

        @Override
        @NotNull
        public final Optional<F> toFinalWithField(@NotNull R r, @NotNull F field) {
            return Optional.ofNullable(this.toFinalWithField.apply(r, field));
        }

        @Override
        @NotNull
        public final Optional<R> toRaw(@NotNull F f) {
            return Optional.ofNullable(this.toRaw.apply(f));
        }

        @Override
        public GenericDeclaration getLeftType() {
            return this.holder.getLeftType();
        }

        @Override
        public GenericPair getPair() {
            return this.holder.getPair();
        }

        @Override
        public GenericDeclaration getRightType() {
            return this.holder.getRightType();
        }
    }
}

