/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper;

import cloud.commandframework.execution.CommandExecutionCoordinator;
import cloud.commandframework.paper.PaperCommandManager;
import com.karuslabs.commons.command.dispatcher.Dispatcher;
import io.github.slimjar.app.builder.ApplicationBuilder;
import io.github.slimjar.logging.ProcessLogger;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.Initializer;
import tr.com.infumia.infumialib.platform.paper.smartinventory.SmartInventory;
import tr.com.infumia.infumialib.platform.paper.smartinventory.manager.BasicSmartInventory;

public final class InfumiaLib
extends JavaPlugin {
    @Nullable
    private static InfumiaLib instance;
    private final SmartInventory inventory = new BasicSmartInventory((Plugin)this);

    @NotNull
    public static PaperCommandManager<CommandSender> createCommandManager(@NotNull Plugin plugin) {
        PaperCommandManager manager;
        try {
            manager = new PaperCommandManager(plugin, CommandExecutionCoordinator.simpleCoordinator(), Function.identity(), Function.identity());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            manager.registerBrigadier();
        }
        catch (Exception e) {
            plugin.getLogger().warning("Couldn't add brigadier support.");
        }
        try {
            manager.registerAsynchronousCompletions();
        }
        catch (Exception e) {
            plugin.getLogger().warning("Couldn't add async tab completion support.");
        }
        return manager;
    }

    @NotNull
    public static InfumiaLib instance() {
        return Objects.requireNonNull(instance, "not initiated");
    }

    @NotNull
    public static SmartInventory inventory() {
        return InfumiaLib.instance().inventory;
    }

    @NotNull
    public Dispatcher dispatcher() {
        return Initializer.dispatcher(this);
    }

    public void loadFiles() {
        Initializer.loadFiles(this);
    }

    public void onLoad() {
        instance = this;
        this.loadDependencies();
        Initializer.load(this);
    }

    public void onEnable() {
        Initializer.enable(this);
    }

    private void loadDependencies() {
        this.getSLF4JLogger().info("Loading dependencies, this might take a while...");
        try {
            ApplicationBuilder.appending("InfumiaLibrary").logger(new ProcessLogger(){

                @Override
                public void log(String s, Object ... objects) {
                    InfumiaLib.this.getSLF4JLogger().info(MessageFormat.format(s, objects));
                }

                @Override
                public void debug(String message, Object ... args) {
                    InfumiaLib.this.getSLF4JLogger().debug(MessageFormat.format(message, args));
                }
            }).downloadDirectoryPath(Paths.get(this.getDataFolder().getAbsolutePath(), new String[0]).resolve("libs")).build();
        }
        catch (IOException | ReflectiveOperationException | URISyntaxException | NoSuchAlgorithmException e) {
            this.getSLF4JLogger().error(String.format("%s-v%s", ((Object)((Object)this)).getClass().getSimpleName(), this.getDescription().getVersion()), (Throwable)e);
            this.getSLF4JLogger().error("Infumia Library failed to load its dependencies correctly!");
            this.getSLF4JLogger().error("This error should be reported at https://github.com/Infumia/InfumiaLib/issues");
            this.onDisable();
        }
    }
}

