/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.account;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.account.Account;
import tr.com.infumia.infumialib.shared.registries.Registry;

public interface AccountStore {
    @NotNull
    public static AccountStore create() {
        return new Impl();
    }

    @NotNull
    public Optional<Account> get(@NotNull String var1);

    public void put(@NotNull Account var1);

    public void remove(@NotNull String var1);

    public static final class Impl
    implements AccountStore {
        private final Registry<String, Account> registry = new Registry();

        @Override
        @NotNull
        public Optional<Account> get(@NotNull String uniqueId) {
            return this.registry.get(uniqueId);
        }

        @Override
        public void put(@NotNull Account account) {
            this.registry.register(account);
        }

        @Override
        public void remove(@NotNull String uniqueId) {
            this.registry.unregister((Account)((Object)uniqueId));
        }

        private Impl() {
        }
    }
}

