/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TaskUtilities {
    @Nullable
    private static Plugin plugin;

    @NotNull
    public static BukkitTask async(@NotNull Runnable job) {
        return Bukkit.getScheduler().runTaskAsynchronously(TaskUtilities.getPlugin(), job);
    }

    @NotNull
    public static BukkitTask asyncLater(long delay, @NotNull Runnable job) {
        return Bukkit.getScheduler().runTaskLaterAsynchronously(TaskUtilities.getPlugin(), job, delay);
    }

    @NotNull
    public static BukkitTask asyncTimer(long period, @NotNull Runnable job) {
        return TaskUtilities.asyncTimerLater(0L, period, job);
    }

    @NotNull
    public static BukkitTask asyncTimer(long period, @NotNull Supplier<Boolean> job) {
        return TaskUtilities.asyncTimerLater(0L, period, job);
    }

    @NotNull
    public static BukkitTask asyncTimerLater(long delay, long period, final @NotNull Supplier<Boolean> job) {
        return new BukkitRunnable(){

            public void run() {
                if (!((Boolean)job.get()).booleanValue()) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously(TaskUtilities.getPlugin(), delay, period);
    }

    @NotNull
    public static BukkitTask asyncTimerLater(long delay, long period, @NotNull Runnable job) {
        return Bukkit.getScheduler().runTaskTimerAsynchronously(TaskUtilities.getPlugin(), job, delay, period);
    }

    public static void init(@NotNull Plugin plugin) {
        TaskUtilities.plugin = plugin;
    }

    @NotNull
    public static <T> BukkitTask runForAll(@NotNull List<T> objects, @NotNull Consumer<T> job) {
        return TaskUtilities.runForAll(1, objects, job);
    }

    @NotNull
    public static <T> BukkitTask runForAll(int perTick, List<T> objects, @NotNull Consumer<T> job) {
        return TaskUtilities.runForAll(perTick, objects, job, () -> {});
    }

    @NotNull
    public static <T> BukkitTask runForAll(final int perTick, final @NotNull List<T> objects, final @NotNull Consumer<T> job, final @NotNull Runnable onDone) {
        return new BukkitRunnable(){
            private int current = 0;

            public void run() {
                IntStream.range(0, perTick).takeWhile(i -> this.current < objects.size()).mapToObj(i -> objects.get(this.current)).forEach(object -> {
                    try {
                        job.accept(object);
                    }
                    catch (RuntimeException e) {
                        TaskUtilities.getPlugin().getLogger().log(Level.SEVERE, "TaskUtilities#forAll() iteration failed for object: " + object + (String)(object != null ? " (" + object.getClass().getName() + ")" : ""), e);
                    }
                    ++this.current;
                });
                if (this.current >= objects.size()) {
                    this.cancel();
                    onDone.run();
                }
            }
        }.runTaskTimer(TaskUtilities.getPlugin(), 1L, 1L);
    }

    @NotNull
    public static BukkitTask sync(@NotNull Runnable job) {
        return Bukkit.getScheduler().runTask(TaskUtilities.getPlugin(), job);
    }

    @NotNull
    public static BukkitTask syncLater(long delay, @NotNull Runnable job) {
        return Bukkit.getScheduler().runTaskLater(TaskUtilities.getPlugin(), job, delay);
    }

    @NotNull
    public static BukkitTask syncTimer(long period, @NotNull Runnable job) {
        return TaskUtilities.syncTimerLater(0L, period, job);
    }

    @NotNull
    public static BukkitTask syncTimer(long period, @NotNull Supplier<Boolean> job) {
        return TaskUtilities.syncTimerLater(0L, period, job);
    }

    @NotNull
    public static BukkitTask syncTimerLater(long delay, long period, final @NotNull Supplier<Boolean> job) {
        return new BukkitRunnable(){

            public void run() {
                if (!((Boolean)job.get()).booleanValue()) {
                    this.cancel();
                }
            }
        }.runTaskTimer(TaskUtilities.getPlugin(), delay, period);
    }

    @NotNull
    public static BukkitTask syncTimerLater(long delay, long period, @NotNull Runnable job) {
        return Bukkit.getScheduler().runTaskTimer(TaskUtilities.getPlugin(), job, delay, period);
    }

    @NotNull
    private static Plugin getPlugin() {
        return Optional.ofNullable(plugin).orElseThrow(() -> new RuntimeException("Use TaskUtilities#init(Plugin) first!"));
    }

    private TaskUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

