/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.utils;

import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class InventoryUtilities {
    public static boolean isInventoryFull(@NotNull Player player, @NotNull ItemStack item) {
        if (item.getType() == Material.AIR) {
            return false;
        }
        if (item.getAmount() > 5000) {
            return true;
        }
        if (player.getInventory().firstEmpty() >= 0 && item.getAmount() <= item.getMaxStackSize()) {
            return false;
        }
        if (item.getAmount() > item.getMaxStackSize()) {
            ItemStack clone = item.clone();
            clone.setAmount(item.getMaxStackSize());
            if (InventoryUtilities.isInventoryFull(player, clone)) {
                return true;
            }
            clone.setAmount(item.getAmount() - item.getMaxStackSize());
            return InventoryUtilities.isInventoryFull(player, clone);
        }
        HashMap all = player.getInventory().all(item);
        int amount = item.getAmount();
        for (ItemStack element : all.values()) {
            amount -= element.getMaxStackSize() - element.getAmount();
        }
        return amount > 0;
    }

    public static boolean isInventoryNotFull(@NotNull Player player, @NotNull ItemStack item) {
        return !InventoryUtilities.isInventoryFull(player, item);
    }

    private InventoryUtilities() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

