/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.hooks.hooks;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.hooks.Hook;
import tr.com.infumia.infumialib.paper.hooks.hooks.BentoBoxWrapper;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.AddonClassLoader;

public final class BentoBoxHook
implements Hook<BentoBoxWrapper> {
    public static final String BENTO_BOX_ID = "BentoBox";
    @Nullable
    private BentoBox bentoBox;

    @Override
    @NotNull
    public BentoBoxWrapper create() {
        if (this.bentoBox == null) {
            throw new IllegalStateException("BentoBox not initiated! Use BentoBoxHook#initiate() method.");
        }
        Optional addon = this.bentoBox.getAddonsManager().getAddonByName("Level");
        if (addon.isEmpty()) {
            throw new IllegalStateException("BentoBox not initiated! Use BentoBoxHook#initiate() method.");
        }
        AddonClassLoader loader = this.bentoBox.getAddonsManager().getLoader((Addon)addon.get());
        if (loader == null) {
            throw new IllegalStateException("Couldn't find any AddonClassLoader instance.");
        }
        return new BentoBoxWrapper(this.bentoBox, loader);
    }

    @Override
    @NotNull
    public String id() {
        return BENTO_BOX_ID;
    }

    @Override
    public boolean initiate() {
        if (Bukkit.getPluginManager().getPlugin(BENTO_BOX_ID) != null) {
            this.bentoBox = BentoBox.getInstance();
        }
        return this.bentoBox != null && this.bentoBox.getAddonsManager().getAddonByName("Level").isPresent();
    }
}

