/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.hooks;

import io.github.portlek.bukkititembuilder.util.ColorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Hook;
import tr.com.infumia.infumialib.hooks.Wrapped;
import tr.com.infumia.infumialib.paper.hooks.hooks.BentoBoxHook;
import tr.com.infumia.infumialib.paper.hooks.hooks.BentoBoxWrapper;
import tr.com.infumia.infumialib.paper.hooks.hooks.GroupManagerHook;
import tr.com.infumia.infumialib.paper.hooks.hooks.GroupManagerWrapper;
import tr.com.infumia.infumialib.paper.hooks.hooks.LuckPermsHook;
import tr.com.infumia.infumialib.paper.hooks.hooks.LuckPermsWrapper;
import tr.com.infumia.infumialib.paper.hooks.hooks.PermissionsExHook;
import tr.com.infumia.infumialib.paper.hooks.hooks.PermissionsExWrapper;
import tr.com.infumia.infumialib.paper.hooks.hooks.PlaceholderAPIHook;
import tr.com.infumia.infumialib.paper.hooks.hooks.PlaceholderAPIWrapper;
import tr.com.infumia.infumialib.paper.hooks.hooks.VaultHook;
import tr.com.infumia.infumialib.paper.hooks.hooks.VaultWrapper;

public final class Hooks {
    private static final Map<String, Wrapped> WRAPPERS = new HashMap<String, Wrapped>();

    public static void addHook(@NotNull Hook<?> hook) {
        if (hook.initiate()) {
            String id = hook.id();
            WRAPPERS.put(id, (Wrapped)hook.create());
            Bukkit.getConsoleSender().sendMessage(ColorUtil.colored(String.format("%s is hooking", id)));
        }
    }

    @NotNull
    public static Optional<BentoBoxWrapper> getBentoBox() {
        return Hooks.getWrapper("BentoBox");
    }

    @NotNull
    public static BentoBoxWrapper getBentoBoxOrThrow() {
        return Hooks.getBentoBox().orElseThrow();
    }

    @NotNull
    public static Optional<GroupManagerWrapper> getGroupManager() {
        return Hooks.getWrapper("GroupManager");
    }

    @NotNull
    public static GroupManagerWrapper getGroupManagerOrThrow() {
        return Hooks.getGroupManager().orElseThrow();
    }

    @NotNull
    public static Optional<LuckPermsWrapper> getLuckPerms() {
        return Hooks.getWrapper("LuckPerms");
    }

    @NotNull
    public static LuckPermsWrapper getLuckPermsOrThrow() {
        return Hooks.getLuckPerms().orElseThrow();
    }

    @NotNull
    public static Optional<PermissionsExWrapper> getPermissionsEx() {
        return Hooks.getWrapper("PermissionsEx");
    }

    @NotNull
    public static PermissionsExWrapper getPermissionsExOrThrow() {
        return Hooks.getPermissionsEx().orElseThrow();
    }

    @NotNull
    public static Optional<PlaceholderAPIWrapper> getPlaceholderAPI() {
        return Hooks.getWrapper("PlaceholderAPI");
    }

    @NotNull
    public static PlaceholderAPIWrapper getPlaceholderAPIOrThrow() {
        return Hooks.getPlaceholderAPI().orElseThrow();
    }

    @NotNull
    public static Optional<VaultWrapper> getVault() {
        return Hooks.getWrapper("Vault");
    }

    @NotNull
    public static VaultWrapper getVaultOrThrow() {
        return Hooks.getVault().orElseThrow();
    }

    public static void loadHooks() {
        Hooks.addHook(new LuckPermsHook());
        Hooks.addHook(new PlaceholderAPIHook());
        Hooks.addHook(new VaultHook());
        Hooks.addHook(new BentoBoxHook());
        Hooks.addHook(new GroupManagerHook());
        Hooks.addHook(new PermissionsExHook());
    }

    @NotNull
    private static <T extends Wrapped> Optional<T> getWrapper(@NotNull String wrappedId) {
        return Optional.ofNullable(WRAPPERS.get(wrappedId)).map(o -> o);
    }

    private Hooks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

