/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Wrapped;
import tr.com.infumia.infumialib.paper.hooks.Hooks;
import tr.com.infumia.infumialib.paper.hooks.hooks.GroupManagerWrapper;
import tr.com.infumia.infumialib.paper.hooks.hooks.LuckPermsWrapper;
import tr.com.infumia.infumialib.paper.hooks.hooks.PermissionsExWrapper;

public final class Groups {
    public static boolean containsGroup(@NotNull String group, @NotNull Player player) {
        return Hooks.getGroupManager().map(wrapper -> Groups.containsGroup(wrapper, group, player)).orElse(Hooks.getLuckPerms().map(wrapper -> Groups.containsGroup(wrapper, group, player)).orElse(Hooks.getPermissionsEx().map(wrapper -> Groups.containsGroup(wrapper, group, player)).orElse(false)));
    }

    public static boolean containsGroup(@NotNull Wrapped wrapper, @NotNull String group, @NotNull Player player) {
        if (wrapper instanceof GroupManagerWrapper) {
            return ((GroupManagerWrapper)wrapper).getGroup(player.getWorld().getName(), player).orElse("").equalsIgnoreCase(group);
        }
        if (wrapper instanceof LuckPermsWrapper) {
            return ((LuckPermsWrapper)wrapper).getGroup(player.getWorld().getName(), player).orElse("").equalsIgnoreCase(group);
        }
        if (wrapper instanceof PermissionsExWrapper) {
            return ((List)((PermissionsExWrapper)wrapper).getGroups(player.getWorld().getName(), player).orElse(new ArrayList())).contains(group);
        }
        return false;
    }

    @NotNull
    public static Optional<String> getFirstGroup(@NotNull Player player) {
        return Optional.ofNullable(Hooks.getGroupManager().flatMap(wrapper -> Groups.getFirstGroup(wrapper, player)).orElse(Hooks.getLuckPerms().flatMap(wrapper -> Groups.getFirstGroup(wrapper, player)).orElse(Hooks.getPermissionsEx().flatMap(wrapper -> Groups.getFirstGroup(wrapper, player)).orElse(null))));
    }

    @NotNull
    public static Optional<String> getFirstGroup(@NotNull Wrapped wrapper, @NotNull Player player) {
        if (wrapper instanceof GroupManagerWrapper) {
            return ((GroupManagerWrapper)wrapper).getGroup(player.getWorld().getName(), player);
        }
        if (wrapper instanceof LuckPermsWrapper) {
            return ((LuckPermsWrapper)wrapper).getGroup(player.getWorld().getName(), player);
        }
        if (wrapper instanceof PermissionsExWrapper) {
            return ((PermissionsExWrapper)wrapper).getGroups(player.getWorld().getName(), player).filter(strings -> !strings.isEmpty()).map(strings -> (String)strings.get(0));
        }
        return Optional.empty();
    }

    private Groups() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

