/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.function.FunctionThrows;

class GitHubResponse<T> {
    private static final Logger LOGGER = Logger.getLogger(GitHubResponse.class.getName());
    private final int statusCode;
    @Nonnull
    private final GitHubRequest request;
    @Nonnull
    private final Map<String, List<String>> headers;
    @CheckForNull
    private final T body;

    GitHubResponse(GitHubResponse<T> response, @CheckForNull T body) {
        this.statusCode = response.statusCode();
        this.request = response.request();
        this.headers = response.headers();
        this.body = body;
    }

    GitHubResponse(ResponseInfo responseInfo, @CheckForNull T body) {
        this.statusCode = responseInfo.statusCode();
        this.request = responseInfo.request();
        this.headers = responseInfo.headers();
        this.body = body;
    }

    @CheckForNull
    static <T> T parseBody(ResponseInfo responseInfo, Class<T> type) throws IOException {
        if (responseInfo.statusCode() == 204) {
            if (type != null && type.isArray()) {
                return type.cast(Array.newInstance(type.getComponentType(), 0));
            }
            return null;
        }
        String data = responseInfo.getBodyAsString();
        try {
            InjectableValues.Std inject = new InjectableValues.Std();
            inject.addValue(ResponseInfo.class, (Object)responseInfo);
            return GitHubClient.getMappingObjectReader(responseInfo).forType(type).readValue(data);
        }
        catch (JsonParseException | JsonMappingException e) {
            String message = "Failed to deserialize: " + data;
            LOGGER.log(Level.FINE, message);
            throw e;
        }
    }

    @CheckForNull
    static <T> T parseBody(ResponseInfo responseInfo, T instance) throws IOException {
        String data = responseInfo.getBodyAsString();
        try {
            return GitHubClient.getMappingObjectReader(responseInfo).withValueToUpdate(instance).readValue(data);
        }
        catch (JsonParseException | JsonMappingException e) {
            String message = "Failed to deserialize: " + data;
            LOGGER.log(Level.FINE, message);
            throw e;
        }
    }

    @Nonnull
    public URL url() {
        return this.request.url();
    }

    @Nonnull
    public GitHubRequest request() {
        return this.request;
    }

    public int statusCode() {
        return this.statusCode;
    }

    @Nonnull
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @CheckForNull
    public String headerField(String name) {
        String result = null;
        if (this.headers.containsKey(name)) {
            result = this.headers.get(name).get(0);
        }
        return result;
    }

    public T body() {
        return this.body;
    }

    static abstract class ResponseInfo
    implements Closeable {
        private static final Comparator<String> nullableCaseInsensitiveComparator = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
        private final int statusCode;
        @Nonnull
        private final GitHubRequest request;
        @Nonnull
        private final Map<String, List<String>> headers;

        protected ResponseInfo(@Nonnull GitHubRequest request, int statusCode, @Nonnull Map<String, List<String>> headers) {
            this.request = request;
            this.statusCode = statusCode;
            TreeMap<String, List<String>> caseInsensitiveMap = new TreeMap<String, List<String>>(nullableCaseInsensitiveComparator);
            caseInsensitiveMap.putAll(headers);
            this.headers = Collections.unmodifiableMap(caseInsensitiveMap);
        }

        @CheckForNull
        public String headerField(String name) {
            String result = null;
            if (this.headers.containsKey(name)) {
                result = this.headers.get(name).get(0);
            }
            return result;
        }

        abstract InputStream bodyStream() throws IOException;

        abstract String errorMessage();

        @Nonnull
        public URL url() {
            return this.request.url();
        }

        @Nonnull
        public GitHubRequest request() {
            return this.request;
        }

        public int statusCode() {
            return this.statusCode;
        }

        @Nonnull
        public Map<String, List<String>> headers() {
            return this.headers;
        }

        @Nonnull
        String getBodyAsString() throws IOException {
            InputStreamReader r = null;
            r = new InputStreamReader(this.bodyStream(), StandardCharsets.UTF_8);
            return IOUtils.toString(r);
        }
    }

    @FunctionalInterface
    static interface BodyHandler<T>
    extends FunctionThrows<ResponseInfo, T, IOException> {
    }
}

