/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.util;

import java.util.stream.Stream;
import net.kyori.adventure.util.HSVLikeImpl;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.value.qual.IntRange;

public interface HSVLike
extends Examinable {
    public static @NonNull HSVLike of(float h2, float s2, float v) {
        return new HSVLikeImpl(h2, s2, v);
    }

    public static @NonNull HSVLike fromRGB(@IntRange(from=0L, to=255L) int red, @IntRange(from=0L, to=255L) int green, @IntRange(from=0L, to=255L) int blue) {
        float r = (float)red / 255.0f;
        float g2 = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float min2 = Math.min(r, Math.min(g2, b));
        float max = Math.max(r, Math.max(g2, b));
        float delta = max - min2;
        float s2 = max != 0.0f ? delta / max : 0.0f;
        if (s2 == 0.0f) {
            return new HSVLikeImpl(0.0f, s2, max);
        }
        float h2 = r == max ? (g2 - b) / delta : (g2 == max ? 2.0f + (b - r) / delta : 4.0f + (r - g2) / delta);
        if ((h2 *= 60.0f) < 0.0f) {
            h2 += 360.0f;
        }
        return new HSVLikeImpl(h2 / 360.0f, s2, max);
    }

    public float h();

    public float s();

    public float v();

    @Override
    default public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("h", this.h()), ExaminableProperty.of("s", this.s()), ExaminableProperty.of("v", this.v()));
    }
}

