/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.NBTComponentImpl;
import net.kyori.adventure.text.format.Style;
import net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class EntityNBTComponentImpl
extends NBTComponentImpl<EntityNBTComponent, EntityNBTComponent.Builder>
implements EntityNBTComponent {
    private final String selector;

    EntityNBTComponentImpl(@NonNull List<? extends ComponentLike> children, @NonNull Style style, String nbtPath, boolean interpret, String selector) {
        super(children, style, nbtPath, interpret);
        this.selector = selector;
    }

    @Override
    public @NonNull EntityNBTComponent nbtPath(@NonNull String nbtPath) {
        if (Objects.equals(this.nbtPath, nbtPath)) {
            return this;
        }
        return new EntityNBTComponentImpl(this.children, this.style, nbtPath, this.interpret, this.selector);
    }

    @Override
    public @NonNull EntityNBTComponent interpret(boolean interpret) {
        if (this.interpret == interpret) {
            return this;
        }
        return new EntityNBTComponentImpl(this.children, this.style, this.nbtPath, interpret, this.selector);
    }

    @Override
    public @NonNull String selector() {
        return this.selector;
    }

    @Override
    public @NonNull EntityNBTComponent selector(@NonNull String selector) {
        if (Objects.equals(this.selector, selector)) {
            return this;
        }
        return new EntityNBTComponentImpl(this.children, this.style, this.nbtPath, this.interpret, selector);
    }

    @Override
    public @NonNull EntityNBTComponent children(@NonNull List<? extends ComponentLike> children) {
        return new EntityNBTComponentImpl(children, this.style, this.nbtPath, this.interpret, this.selector);
    }

    @Override
    public @NonNull EntityNBTComponent style(@NonNull Style style) {
        return new EntityNBTComponentImpl(this.children, style, this.nbtPath, this.interpret, this.selector);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EntityNBTComponent)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        EntityNBTComponentImpl that = (EntityNBTComponentImpl)other;
        return Objects.equals(this.selector, that.selector());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.selector.hashCode();
        return result;
    }

    @Override
    protected @NonNull Stream<? extends ExaminableProperty> examinablePropertiesWithoutChildren() {
        return Stream.concat(Stream.of(ExaminableProperty.of("selector", this.selector)), super.examinablePropertiesWithoutChildren());
    }

    @Override
    public @NonNull EntityNBTComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    extends NBTComponentImpl.BuilderImpl<EntityNBTComponent, EntityNBTComponent.Builder>
    implements EntityNBTComponent.Builder {
        private @Nullable String selector;

        BuilderImpl() {
        }

        BuilderImpl(@NonNull EntityNBTComponent component) {
            super(component);
            this.selector = component.selector();
        }

        @Override
        public @NonNull EntityNBTComponent.Builder selector(@NonNull String selector) {
            this.selector = selector;
            return this;
        }

        @Override
        public @NonNull EntityNBTComponent build() {
            if (this.nbtPath == null) {
                throw new IllegalStateException("nbt path must be set");
            }
            if (this.selector == null) {
                throw new IllegalStateException("selector must be set");
            }
            return new EntityNBTComponentImpl(this.children, this.buildStyle(), this.nbtPath, this.interpret, this.selector);
        }
    }
}

