/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.util;

import io.github.portlek.smartinventory.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TitleUpdater {
    private static final Class<?> CHAT_MESSAGE_CLASS;
    private static final Class<?> CONTAINERS_CLASS;
    private static final Class<?> CONTAINER_CLASS;
    private static final Class<?> CRAFT_PLAYER_CLASS;
    private static final Class<?> ENTITY_PLAYER_CLASS;
    private static final Class<?> I_CHAT_BASE_COMPONENT_CLASS;
    private static final Class<?> PACKET_PLAY_OUT_OPEN_WINDOW_CLASS;
    private static Field activeContainerField;
    private static Constructor<?> chatMessageConstructor;
    private static Method getBukkitView;
    private static Method getHandle;
    private static Constructor<?> packetPlayOutOpenWindowConstructor;
    private static Method updateInventory;
    private static Field windowIdField;

    private TitleUpdater() {
    }

    public static void updateInventory(@NotNull Player player, @Nullable String newTitle) {
        String newTitleTemp = newTitle;
        Objects.requireNonNull(player, "Cannot update inventory to null player");
        try {
            Object craftPlayer = CRAFT_PLAYER_CLASS.cast(player);
            Object entityPlayer = getHandle.invoke(craftPlayer, new Object[0]);
            if (newTitleTemp != null && newTitleTemp.length() > 32) {
                newTitleTemp = newTitleTemp.substring(0, 32);
            }
            Object title = chatMessageConstructor.newInstance(newTitleTemp != null ? newTitleTemp : "", new Object[0]);
            Object activeContainer = activeContainerField.get(entityPlayer);
            Integer windowId = (Integer)windowIdField.get(activeContainer);
            Object bukkitView = getBukkitView.invoke(activeContainer, new Object[0]);
            if (!(bukkitView instanceof InventoryView)) {
                return;
            }
            InventoryView view = (InventoryView)bukkitView;
            InventoryType type = view.getTopInventory().getType();
            if (!(type != InventoryType.WORKBENCH && type != InventoryType.ANVIL || TitleUpdater.useContainers())) {
                return;
            }
            if (type == InventoryType.CRAFTING || type == InventoryType.CREATIVE || type == InventoryType.PLAYER) {
                return;
            }
            int size = view.getTopInventory().getSize();
            Containers container = Containers.getType(type, size);
            if (container == null) {
                return;
            }
            if (container.getContainerVersion() > TitleUpdater.getVersion() && TitleUpdater.useContainers()) {
                Bukkit.getLogger().warning("This container doesn't work on your current version.");
                return;
            }
            Object object = !TitleUpdater.useContainers() && container == Containers.GENERIC_3X3 ? "minecraft:" + type.name().toLowerCase() : container.getObject();
            Object packet = TitleUpdater.useContainers() ? packetPlayOutOpenWindowConstructor.newInstance(windowId, object, title) : packetPlayOutOpenWindowConstructor.newInstance(windowId, object, title, size);
            ReflectionUtils.sendPacket(player, packet);
            updateInventory.invoke(entityPlayer, activeContainer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int getVersion() {
        return Integer.parseInt(ReflectionUtils.VERSION.split("_")[1]);
    }

    private static boolean useContainers() {
        return TitleUpdater.getVersion() > 13;
    }

    static {
        CRAFT_PLAYER_CLASS = ReflectionUtils.getCraftClass("entity.CraftPlayer");
        CHAT_MESSAGE_CLASS = ReflectionUtils.getNMSClass("ChatMessage");
        PACKET_PLAY_OUT_OPEN_WINDOW_CLASS = ReflectionUtils.getNMSClass("PacketPlayOutOpenWindow");
        I_CHAT_BASE_COMPONENT_CLASS = ReflectionUtils.getNMSClass("IChatBaseComponent");
        CONTAINERS_CLASS = TitleUpdater.useContainers() ? ReflectionUtils.getNMSClass("Containers") : null;
        ENTITY_PLAYER_CLASS = ReflectionUtils.getNMSClass("EntityPlayer");
        CONTAINER_CLASS = ReflectionUtils.getNMSClass("Container");
        try {
            getHandle = CRAFT_PLAYER_CLASS.getMethod("getHandle", new Class[0]);
            getBukkitView = CONTAINER_CLASS.getMethod("getBukkitView", new Class[0]);
            updateInventory = ENTITY_PLAYER_CLASS.getMethod("updateInventory", CONTAINER_CLASS);
            chatMessageConstructor = CHAT_MESSAGE_CLASS.getConstructor(String.class, Object[].class);
            packetPlayOutOpenWindowConstructor = TitleUpdater.useContainers() ? PACKET_PLAY_OUT_OPEN_WINDOW_CLASS.getConstructor(Integer.TYPE, CONTAINERS_CLASS, I_CHAT_BASE_COMPONENT_CLASS) : PACKET_PLAY_OUT_OPEN_WINDOW_CLASS.getConstructor(Integer.TYPE, String.class, I_CHAT_BASE_COMPONENT_CLASS, Integer.TYPE);
            activeContainerField = ENTITY_PLAYER_CLASS.getField("activeContainer");
            windowIdField = CONTAINER_CLASS.getField("windowId");
        }
        catch (NoSuchFieldException | NoSuchMethodException exception) {
            exception.printStackTrace();
        }
    }

    public static enum Containers {
        GENERIC_9X1(14, "minecraft:chest", "CHEST"),
        GENERIC_9X2(14, "minecraft:chest", "CHEST"),
        GENERIC_9X3(14, "minecraft:chest", "CHEST", "ENDER_CHEST", "BARREL"),
        GENERIC_9X4(14, "minecraft:chest", "CHEST"),
        GENERIC_9X5(14, "minecraft:chest", "CHEST"),
        GENERIC_9X6(14, "minecraft:chest", "CHEST"),
        GENERIC_3X3(14, null, "DISPENSER", "DROPPER"),
        ANVIL(14, "minecraft:anvil", "ANVIL"),
        BEACON(14, "minecraft:beacon", "BEACON"),
        BREWING_STAND(14, "minecraft:brewing_stand", "BREWING"),
        ENCHANTMENT(14, "minecraft:enchanting_table", "ENCHANTING"),
        FURNACE(14, "minecraft:furnace", "FURNACE"),
        HOPPER(14, "minecraft:hopper", "HOPPER"),
        MERCHANT(14, "minecraft:villager", "MERCHANT"),
        SHULKER_BOX(14, "minecraft:blue_shulker_box", "SHULKER_BOX"),
        BLAST_FURNACE(14, null, "BLAST_FURNACE"),
        CRAFTING(14, null, "WORKBENCH"),
        GRINDSTONE(14, null, "GRINDSTONE"),
        LECTERN(14, null, "LECTERN"),
        LOOM(14, null, "LOOM"),
        SMOKER(14, null, "SMOKER"),
        CARTOGRAPHY_TABLE(14, null, "CARTOGRAPHY"),
        STONE_CUTTER(14, null, "STONECUTTER"),
        SMITHING(16, null, "SMITHING");

        private final int containerVersion;
        private final String[] inventoryTypesNames;
        private final String minecraftName;

        private Containers(int containerVersion, String minecraftName, String ... inventoryTypesNames) {
            this.containerVersion = containerVersion;
            this.minecraftName = minecraftName;
            this.inventoryTypesNames = inventoryTypesNames;
        }

        @Nullable
        public static Containers getType(InventoryType type, int size) {
            if (type == InventoryType.CHEST) {
                return Containers.valueOf("GENERIC_9X" + size / 9);
            }
            return Arrays.stream(Containers.values()).filter(container -> Arrays.stream(container.getInventoryTypesNames()).anyMatch(bukkitName -> bukkitName.equalsIgnoreCase(type.toString()))).findFirst().orElse(null);
        }

        @Nullable
        public Object getObject() {
            try {
                if (!TitleUpdater.useContainers()) {
                    return this.getMinecraftName();
                }
                String name = TitleUpdater.getVersion() == 14 && this == CARTOGRAPHY_TABLE ? "CARTOGRAPHY" : this.name();
                Field field = CONTAINERS_CLASS.getField(name);
                return field.get(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public int getContainerVersion() {
            return this.containerVersion;
        }

        public String[] getInventoryTypesNames() {
            return this.inventoryTypesNames;
        }

        public String getMinecraftName() {
            return this.minecraftName;
        }
    }
}

