/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.util;

import com.google.common.base.Preconditions;
import io.github.portlek.smartinventory.util.SlotPos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pattern<T> {
    @NotNull
    private final String[] lines;
    private final Map<Character, T> mapping = new HashMap<Character, T>();
    private final boolean wrapAround;
    @Nullable
    private T defaultValue;

    public Pattern(String ... lines) {
        this(false, lines);
    }

    public Pattern(boolean wrapAround, String ... lines) {
        Preconditions.checkArgument((lines.length > 0 ? 1 : 0) != 0, (Object)"The given pattern lines must not be empty.");
        int count = lines[0].length();
        this.lines = new String[lines.length];
        IntStream.range(0, lines.length).forEach(i -> {
            String line = lines[i];
            Preconditions.checkNotNull((Object)line, (String)"The given pattern line %s cannot be null.", (int)i);
            Preconditions.checkArgument((line.length() == count ? 1 : 0) != 0, (String)"The given pattern line %s does not match the first line character count.", (int)i);
            this.lines[i] = lines[i];
        });
        this.wrapAround = wrapAround;
    }

    @NotNull
    public Pattern<T> attach(char character, @NotNull T object) {
        this.mapping.put(Character.valueOf(character), object);
        return this;
    }

    @NotNull
    public List<SlotPos> findAllKeys(char character) {
        ArrayList<SlotPos> positions = new ArrayList<SlotPos>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                if (this.lines[row].charAt(column) != character) continue;
                positions.add(SlotPos.of(row, column));
            }
        }
        return positions;
    }

    @NotNull
    public Optional<SlotPos> findKey(char character) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                if (this.lines[row].charAt(column) != character) continue;
                return Optional.of(SlotPos.of(row, column));
            }
        }
        return Optional.empty();
    }

    public int getColumnCount() {
        return this.lines[0].length();
    }

    @NotNull
    public Optional<T> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    @NotNull
    public Optional<T> getObject(int index) {
        int count = this.getColumnCount();
        return this.getObject(index / count, index % count);
    }

    @NotNull
    public Optional<T> getObject(@NotNull SlotPos slot) {
        return this.getObject(slot.getRow(), slot.getColumn());
    }

    @NotNull
    public Optional<T> getObject(int row, int column) {
        int rowCache = row;
        int columnCache = column;
        if (this.wrapAround) {
            if ((rowCache %= this.getRowCount()) < 0) {
                rowCache += this.getRowCount();
            }
            if ((columnCache %= this.getColumnCount()) < 0) {
                columnCache += this.getColumnCount();
            }
        } else {
            Preconditions.checkElementIndex((int)rowCache, (int)this.lines.length, (String)"The row must be between 0 and the row count");
            Preconditions.checkElementIndex((int)columnCache, (int)this.lines[0].length(), (String)"The column must be between 0 and the column size");
        }
        return Optional.ofNullable(this.mapping.getOrDefault(Character.valueOf(this.lines[rowCache].charAt(columnCache)), this.defaultValue));
    }

    public int getRowCount() {
        return this.lines.length;
    }

    public boolean isWrapAround() {
        return this.wrapAround;
    }

    @NotNull
    public Pattern<T> setDefault(@NotNull T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }
}

