/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.listener;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.SmartHolder;
import io.github.portlek.smartinventory.event.IcClickEvent;
import io.github.portlek.smartinventory.event.PgBottomClickEvent;
import io.github.portlek.smartinventory.event.PgClickEvent;
import io.github.portlek.smartinventory.event.PgOutsideClickEvent;
import io.github.portlek.smartinventory.util.SlotPos;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class InventoryClickListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int column;
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof SmartHolder)) {
            return;
        }
        SmartHolder smartHolder = (SmartHolder)holder;
        if (event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
            event.setCancelled(true);
            return;
        }
        Page page = smartHolder.getPage();
        InventoryContents contents = smartHolder.getContents();
        Plugin plugin = smartHolder.getPlugin();
        Inventory clicked = event.getClickedInventory();
        if (clicked == null) {
            page.accept(new PgOutsideClickEvent(contents, event, plugin));
            return;
        }
        HumanEntity player = event.getWhoClicked();
        if (clicked.equals(player.getOpenInventory().getBottomInventory())) {
            page.accept(new PgBottomClickEvent(contents, event, plugin));
            return;
        }
        ItemStack current = event.getCurrentItem();
        if (current == null || current.getType() == Material.AIR) {
            page.accept(new PgClickEvent(contents, event, plugin));
            return;
        }
        int slot = event.getSlot();
        int row = slot / 9;
        if (!page.checkBounds(row, column = slot % 9)) {
            return;
        }
        SlotPos slotPos = SlotPos.of(row, column);
        if (!contents.isEditable(slotPos)) {
            event.setCancelled(true);
        }
        contents.get(slotPos).ifPresent(item -> item.accept(new IcClickEvent(contents, event, (Icon)item, plugin)));
        if (!contents.isEditable(slotPos) && player instanceof Player) {
            ((Player)player).updateInventory();
        }
    }
}

