/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.content;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.Page;
import io.github.portlek.smartinventory.Pagination;
import io.github.portlek.smartinventory.SlotIterator;
import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.content.BasicPagination;
import io.github.portlek.smartinventory.util.SlotPos;
import io.github.portlek.smartinventory.util.TitleUpdater;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicInventoryContents
implements InventoryContents {
    @Nullable
    private final Icon[][] contents;
    private final Set<SlotPos> editableSlots = new HashSet<SlotPos>();
    private final Map<String, SlotIterator> iterators = new HashMap<String, SlotIterator>();
    @NotNull
    private final Page page;
    private final Pagination pagination = new BasicPagination();
    @NotNull
    private final Player player;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public BasicInventoryContents(@NotNull Page page, @NotNull Player player) {
        this(new Icon[page.row()][page.column()], page, player);
    }

    @Override
    @NotNull
    public Icon[][] all() {
        return (Icon[][])this.contents.clone();
    }

    @Override
    @NotNull
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public boolean isEditable(@NotNull SlotPos slot) {
        return this.editableSlots.contains(slot);
    }

    @Override
    @NotNull
    public Optional<SlotIterator> iterator(@NotNull String id) {
        return Optional.ofNullable(this.iterators.get(id));
    }

    @Override
    @NotNull
    public SlotIterator newIterator(@NotNull String id, @NotNull SlotIterator.Type type, int startRow, int startColumn) {
        SlotIterator iterator = this.newIterator(type, startRow, startColumn);
        this.iterators.put(id, iterator);
        return iterator;
    }

    @Override
    @NotNull
    public Page page() {
        return this.page;
    }

    @Override
    @NotNull
    public Pagination pagination() {
        return this.pagination;
    }

    @Override
    @NotNull
    public Player player() {
        return this.player;
    }

    @Override
    @NotNull
    public InventoryContents set(int row, int column, @Nullable Icon item) {
        if (row < 0 || row >= this.contents.length) {
            return this;
        }
        if (column < 0 || column >= this.contents[row].length) {
            return this;
        }
        this.contents[row][column] = item;
        if (item == null) {
            this.update(row, column, null);
        } else {
            this.update(row, column, item.calculateItem(this));
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents setEditable(@NotNull SlotPos slot, boolean editable) {
        if (editable) {
            this.editableSlots.add(slot);
        } else {
            this.editableSlots.remove(slot);
        }
        return this;
    }

    @Override
    @NotNull
    public InventoryContents setProperty(@NotNull String name, @NotNull Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public void updateTitle(@NotNull String newTitle) {
        TitleUpdater.updateInventory(this.player, newTitle);
    }

    private void update(int row, int column, @Nullable ItemStack item) {
        if (SmartInventory.getOpenedPlayers(this.page).contains(this.player())) {
            this.getTopInventory().setItem(this.page.column() * row + column, item);
        }
    }

    public BasicInventoryContents(@Nullable Icon[][] contents, @NotNull Page page, @NotNull Player player) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.contents = contents;
        this.page = page;
        this.player = player;
    }
}

