/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory;

import io.github.portlek.smartinventory.Handle;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.event.abs.ClickEvent;
import io.github.portlek.smartinventory.event.abs.DragEvent;
import io.github.portlek.smartinventory.event.abs.IconEvent;
import io.github.portlek.smartinventory.event.abs.SmartEvent;
import io.github.portlek.smartinventory.icon.BasicIcon;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface Icon {
    public static final Icon EMPTY = Icon.from(new ItemStack(Material.AIR));

    @NotNull
    public static Icon cancel(@NotNull ItemStack item) {
        return Icon.from(item).whenInteract(SmartEvent::cancel);
    }

    @SafeVarargs
    @NotNull
    public static Icon click(@NotNull ItemStack item, @NotNull Consumer<ClickEvent> consumer, Predicate<ClickEvent> ... requirements) {
        return Icon.from(item).whenClick(consumer, Arrays.asList(requirements));
    }

    @SafeVarargs
    @NotNull
    public static Icon drag(@NotNull ItemStack item, @NotNull Consumer<DragEvent> consumer, Predicate<DragEvent> ... requirements) {
        return Icon.from(item).whenDrag(consumer, Arrays.asList(requirements));
    }

    @NotNull
    public static Icon from(@NotNull ItemStack item) {
        return new BasicIcon(item);
    }

    public <T extends IconEvent> void accept(@NotNull T var1);

    @NotNull
    public ItemStack calculateItem(@NotNull InventoryContents var1);

    @NotNull
    public Icon canSee(@NotNull Predicate<InventoryContents> var1);

    @NotNull
    public Icon canUse(@NotNull Predicate<InventoryContents> var1);

    @NotNull
    public Icon fallback(@NotNull ItemStack var1);

    @NotNull
    public ItemStack getItem();

    @NotNull
    default public <T extends IconEvent> Icon handle(@NotNull Class<T> clazz, @NotNull Consumer<T> consumer, @NotNull List<Predicate<T>> requirements) {
        return this.handle(Handle.from(clazz, consumer, requirements));
    }

    @NotNull
    public <T extends IconEvent> Icon handle(@NotNull Handle<T> var1);

    @NotNull
    public Icon handles(@NotNull Collection<Handle<? extends IconEvent>> var1);

    @NotNull
    public Icon item(@NotNull ItemStack var1);

    @NotNull
    default public Icon whenClick(@NotNull Consumer<ClickEvent> consumer) {
        return this.whenClick(consumer, Collections.emptyList());
    }

    @NotNull
    default public Icon whenClick(@NotNull Consumer<ClickEvent> consumer, @NotNull Predicate<ClickEvent> requirement) {
        return this.handle(ClickEvent.class, consumer, Collections.singletonList(requirement));
    }

    @NotNull
    default public Icon whenClick(@NotNull Consumer<ClickEvent> consumer, @NotNull List<Predicate<ClickEvent>> requirements) {
        return this.handle(ClickEvent.class, consumer, requirements);
    }

    @NotNull
    default public Icon whenDrag(@NotNull Consumer<DragEvent> consumer) {
        return this.whenDrag(consumer, Collections.emptyList());
    }

    @NotNull
    default public Icon whenDrag(@NotNull Consumer<DragEvent> consumer, @NotNull Predicate<DragEvent> requirement) {
        return this.whenDrag(consumer, Collections.singletonList(requirement));
    }

    @NotNull
    default public Icon whenDrag(@NotNull Consumer<DragEvent> consumer, @NotNull List<Predicate<DragEvent>> requirements) {
        return this.handle(DragEvent.class, consumer, requirements);
    }

    @NotNull
    default public Icon whenInteract(@NotNull Consumer<IconEvent> consumer) {
        return this.whenInteract(consumer, Collections.emptyList());
    }

    @NotNull
    default public Icon whenInteract(@NotNull Consumer<IconEvent> consumer, @NotNull Predicate<IconEvent> requirement) {
        return this.whenInteract(consumer, Collections.singletonList(requirement));
    }

    @NotNull
    default public Icon whenInteract(@NotNull Consumer<IconEvent> consumer, @NotNull List<Predicate<IconEvent>> requirements) {
        return this.handle(IconEvent.class, consumer, requirements);
    }
}

