/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.equilibrium;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class Utilities {
    private Utilities() {
    }

    static boolean instanceOf(@NotNull Object leftObject, @NotNull Object rightObject) {
        if (!(leftObject instanceof Class) || !(rightObject instanceof Class)) {
            return false;
        }
        return ((Class)rightObject).isAssignableFrom((Class)leftObject);
    }

    static boolean noInstanceOf(@NotNull Object leftObject, @NotNull Object rightObject) {
        return !Utilities.instanceOf(leftObject, rightObject);
    }

    static boolean isBigger(@NotNull Object leftObject, @NotNull Object rightObject) {
        if (!(leftObject instanceof Number) || !(rightObject instanceof Number)) {
            return false;
        }
        Number left = (Number)leftObject;
        Number right = (Number)rightObject;
        if (left instanceof Double) {
            return left.doubleValue() > right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() > right.intValue();
        }
        if (left instanceof Long) {
            return left.longValue() > right.longValue();
        }
        if (left instanceof Float) {
            return left.floatValue() > right.floatValue();
        }
        if (left instanceof Short) {
            return left.shortValue() > right.shortValue();
        }
        if (left instanceof Byte) {
            return left.byteValue() > right.byteValue();
        }
        return false;
    }

    static boolean isBiggerEquals(@NotNull Object leftObject, @NotNull Object rightObject) {
        if (!(leftObject instanceof Number) || !(rightObject instanceof Number)) {
            return false;
        }
        Number left = (Number)leftObject;
        Number right = (Number)rightObject;
        if (left instanceof Double) {
            return left.doubleValue() >= right.doubleValue();
        }
        if (left instanceof Integer) {
            return left.intValue() >= right.intValue();
        }
        if (left instanceof Long) {
            return left.longValue() >= right.longValue();
        }
        if (left instanceof Float) {
            return left.floatValue() >= right.floatValue();
        }
        if (left instanceof Short) {
            return left.shortValue() >= right.shortValue();
        }
        if (left instanceof Byte) {
            return left.byteValue() >= right.byteValue();
        }
        return false;
    }

    static boolean isLess(@NotNull Object leftObject, @NotNull Object rightObject) {
        return !Utilities.isBiggerEquals(leftObject, rightObject);
    }

    static boolean isLessEquals(@NotNull Object leftObject, @NotNull Object rightObject) {
        return !Utilities.isBigger(leftObject, rightObject);
    }

    static boolean equals(@NotNull Object leftObject, @NotNull Object rightObject) {
        return Objects.equals(leftObject, rightObject);
    }

    static boolean notEqual(@NotNull Object leftObject, @NotNull Object rightObject) {
        return !Utilities.equals(leftObject, rightObject);
    }
}

