/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders.impl;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.FieldLoader;
import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.reflection.RefField;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlRawField
extends BaseFieldLoader {
    public static final FieldLoader.Func INSTANCE = FlRawField::new;
    private static final List<Class> GENERICS = List.of(List.class, Map.class);
    private static final List<Class> RAWS = List.of(String.class, Integer.class, Integer.TYPE, Boolean.class, Boolean.TYPE, Long.TYPE, Long.class, Double.TYPE, Double.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Float.TYPE, Float.class, Short.TYPE, Short.class);

    private FlRawField(@NotNull ConfigHolder holder, @NotNull ConfigurationSection section) {
        super(holder, section);
    }

    @Nullable
    private static Object convertFieldType(@NotNull RefField field, @NotNull Object valueAtPath) {
        Class<?> type = field.getType();
        if (type.isAssignableFrom(valueAtPath.getClass())) {
            return valueAtPath;
        }
        if (type == String.class) {
            return valueAtPath.toString();
        }
        return null;
    }

    private static void loadList(@NotNull Object valueAtPath, @NotNull RefField field, @NotNull ConfigurationSection section, @NotNull String path) {
        FlRawField.loadList(valueAtPath, field, null, section, path);
    }

    private static void loadList(@NotNull Object valueAtPath, @NotNull RefField field, @Nullable Object fieldValue, @NotNull ConfigurationSection section, @NotNull String path) {
        if (!(valueAtPath instanceof List)) {
            return;
        }
        List list = (List)valueAtPath;
        if (list.isEmpty()) {
            field.setValue(new ArrayList());
            return;
        }
        Object listObject = list.get(0);
        Class<?> listObjectClass = listObject.getClass();
        if (!RAWS.contains(listObjectClass) && !GENERICS.contains(listObjectClass)) {
            return;
        }
        ParameterizedType genericType = (ParameterizedType)field.getRealField().getGenericType();
        Class genericClass = (Class)genericType.getActualTypeArguments()[0];
        if (genericClass.isAssignableFrom(listObjectClass)) {
            field.setValue(list);
        } else if (fieldValue != null) {
            section.set(path, fieldValue);
        }
    }

    private static void loadMap(@NotNull Object valueAtPath, @NotNull RefField field, @NotNull ConfigurationSection section, @NotNull String path) {
        FlRawField.loadMap(valueAtPath, field, null, section, path);
    }

    private static void loadMap(@NotNull Object valueAtPath, @NotNull RefField field, @Nullable Object fieldValue, @NotNull ConfigurationSection section, @NotNull String path) {
        Map<String, Object> finalValueAtPath = valueAtPath instanceof ConfigurationSection ? ((ConfigurationSection)((Object)valueAtPath)).getMapValues(false) : valueAtPath;
        if (!(finalValueAtPath instanceof Map)) {
            return;
        }
        Map<String, Object> map = finalValueAtPath;
        if (map.isEmpty()) {
            field.setValue(new HashMap());
            return;
        }
        Map.Entry mapEntry = ((Map.Entry[])map.entrySet().toArray(Map.Entry[]::new))[0];
        Object mapEntryKey = mapEntry.getKey();
        Object mapEntryValue = mapEntry.getValue();
        Class<?> mapEntryKeyClass = mapEntryKey.getClass();
        Class<?> mapEntryValueClass = mapEntryValue.getClass();
        if (!RAWS.contains(mapEntryKeyClass) && !GENERICS.contains(mapEntryKeyClass) || !RAWS.contains(mapEntryValueClass) && !GENERICS.contains(mapEntryValueClass)) {
            return;
        }
        ParameterizedType genericType = (ParameterizedType)field.getRealField().getGenericType();
        Class keyClass = (Class)genericType.getActualTypeArguments()[0];
        Class valueClass = (Class)genericType.getActualTypeArguments()[1];
        if (keyClass.isAssignableFrom(mapEntryKeyClass) && valueClass.isAssignableFrom(mapEntryValueClass)) {
            field.setValue(map);
        } else if (fieldValue != null) {
            section.set(path, fieldValue);
        }
    }

    @Override
    public boolean canLoad(@NotNull Loader loader, @NotNull RefField field) {
        return RAWS.contains(field.getType()) || GENERICS.contains(field.getType());
    }

    @Override
    public void onLoad(@NotNull Loader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        Optional<Object> fieldValueOptional = field.of(loader.getConfigHolder()).getValue();
        ConfigurationSection section = this.getSection();
        Object valueAtPath = section.get(path);
        Class<?> fieldType = field.getType();
        if (fieldValueOptional.isPresent()) {
            Object fieldValue = fieldValueOptional.get();
            if (valueAtPath != null) {
                if (GENERICS.contains(fieldType)) {
                    FlRawField.loadList(valueAtPath, field, fieldValue, section, path);
                    FlRawField.loadMap(valueAtPath, field, fieldValue, section, path);
                } else {
                    Object converted = FlRawField.convertFieldType(field, valueAtPath);
                    if (converted == null) {
                        section.set(path, fieldValue);
                    } else {
                        field.setValue(fieldType.cast(converted));
                    }
                }
            } else {
                section.set(path, fieldValue);
            }
        } else if (valueAtPath != null) {
            if (GENERICS.contains(fieldType)) {
                FlRawField.loadList(valueAtPath, field, section, path);
                FlRawField.loadMap(valueAtPath, field, section, path);
            } else {
                field.setValue(fieldType.cast(valueAtPath));
            }
        }
    }
}

