/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.configs.loaders.impl;

import io.github.portlek.configs.ConfigHolder;
import io.github.portlek.configs.ConfigLoader;
import io.github.portlek.configs.FieldLoader;
import io.github.portlek.configs.LangLoader;
import io.github.portlek.configs.Loader;
import io.github.portlek.configs.annotation.Route;
import io.github.portlek.configs.configuration.ConfigurationSection;
import io.github.portlek.configs.lang.LangValue;
import io.github.portlek.configs.loaders.BaseFieldLoader;
import io.github.portlek.reflection.RefField;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class FlLangValueLoader
extends BaseFieldLoader {
    public static final FieldLoader.Func INSTANCE = FlLangValueLoader::new;

    private FlLangValueLoader(@NotNull ConfigHolder holder, @NotNull ConfigurationSection section) {
        super(holder, section);
    }

    @Override
    public boolean canLoad(@NotNull Loader loader, @NotNull RefField field) {
        return field.getType() == LangValue.class && loader.getClass() == LangLoader.class;
    }

    @Override
    public void onLoad(@NotNull Loader loader, @NotNull RefField field) {
        String path = field.getAnnotation(Route.class).map(Route::value).orElse(field.getName());
        LangLoader lang = (LangLoader)loader;
        Optional<LangValue> fieldValueOptional = field.of(lang.getConfigHolder()).getValue().filter(LangValue.class::isInstance).map(LangValue.class::cast);
        for (LangLoader.StringLoaderEntry entry : lang.getBuilt()) {
            String key = entry.getKey();
            ConfigLoader value = entry.getValue();
            ConfigurationSection section = this.getSection();
            Object valueAtPath = section.get(path);
            if (!fieldValueOptional.isPresent() && valueAtPath == null) continue;
        }
    }
}

