/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkitlocation;

import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public final class VectorUtil {
    private VectorUtil() {
    }

    @NotNull
    public static Vector rotateAroundAxisX(@NotNull Vector vector, double angle) {
        double cos = StrictMath.cos(angle);
        double sin = StrictMath.sin(angle);
        return vector.setY(vector.getY() * cos - vector.getZ() * sin).setZ(vector.getY() * sin + vector.getZ() * cos);
    }

    @NotNull
    public static Vector rotateAroundAxisY(@NotNull Vector vector, double angle) {
        double cos = StrictMath.cos(angle);
        double sin = StrictMath.sin(angle);
        return vector.setX(vector.getX() * cos + vector.getZ() * sin).setZ(vector.getX() * -sin + vector.getZ() * cos);
    }

    @NotNull
    public static Vector rotateAroundAxisZ(@NotNull Vector vector, double angle) {
        double cos = StrictMath.cos(angle);
        double sin = StrictMath.sin(angle);
        return vector.setX(vector.getX() * cos - vector.getY() * sin).setY(vector.getX() * sin + vector.getY() * cos);
    }

    @NotNull
    public static Vector rotateVector(@NotNull Vector vector, double angleX, double angleY, double angleZ) {
        return VectorUtil.rotateAroundAxisZ(VectorUtil.rotateAroundAxisY(VectorUtil.rotateAroundAxisX(vector, angleX), angleY), angleZ);
    }

    @NotNull
    public static Vector rotateVector(@NotNull Vector vector, @NotNull Location location) {
        return VectorUtil.rotateVector(vector, location.getYaw(), location.getPitch());
    }

    @NotNull
    public static Vector rotateVector(@NotNull Vector vector, double yawDegrees, double pitchDegrees) {
        double yaw = Math.toRadians(-1.0 * (yawDegrees + 90.0));
        double pitch = Math.toRadians(-pitchDegrees);
        double cosYaw = StrictMath.cos(yaw);
        double cosPitch = StrictMath.cos(pitch);
        double sinYaw = StrictMath.sin(yaw);
        double sinPitch = StrictMath.sin(pitch);
        double initialX = vector.getX() * cosPitch - vector.getY() * sinPitch;
        double initialY = vector.getY();
        double initialZ = vector.getZ();
        double x = initialX * cosPitch - initialY * sinPitch;
        return new Vector(initialZ * sinYaw + x * cosYaw, initialX * sinPitch + initialY * cosPitch, initialZ * cosYaw - x * sinYaw);
    }
}

