/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder;

import com.cryptomorin.xseries.XMaterial;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import io.github.portlek.bukkititembuilder.BannerItemBuilder;
import io.github.portlek.bukkititembuilder.BookItemBuilder;
import io.github.portlek.bukkititembuilder.Builder;
import io.github.portlek.bukkititembuilder.CrossbowItemBuilder;
import io.github.portlek.bukkititembuilder.FireworkItemBuilder;
import io.github.portlek.bukkititembuilder.LeatherArmorItemBuilder;
import io.github.portlek.bukkititembuilder.MapItemBuilder;
import io.github.portlek.bukkititembuilder.SkullItemBuilder;
import io.github.portlek.bukkititembuilder.SpawnEggItemBuilder;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.jetbrains.annotations.NotNull;

public final class ItemStackBuilder
extends Builder<ItemStackBuilder, ItemMeta> {
    private ItemStackBuilder(@NotNull ItemStack itemStack) {
        super(Objects.requireNonNull(itemStack.getItemMeta(), String.format("ItemMeta of %s couldn't get!", itemStack)), itemStack);
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull XMaterial material) {
        Material parsed = material.parseMaterial();
        if (parsed == null) {
            throw new IllegalStateException(String.format("Material from the %s cannot be null!", material.name()));
        }
        return ItemStackBuilder.from(parsed);
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull Material material) {
        return ItemStackBuilder.from(new ItemStack(material));
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull ItemStack itemStack) {
        return new ItemStackBuilder(itemStack);
    }

    @NotNull
    public static ItemStackBuilder from(@NotNull String nbtJson) {
        return ItemStackBuilder.from(NBTEditor.getItemFromTag(NBTEditor.getNBTCompound(nbtJson)));
    }

    @NotNull
    public BannerItemBuilder banner() {
        return new BannerItemBuilder(this.validateMeta(BannerMeta.class), this.getItemStack());
    }

    @NotNull
    public BookItemBuilder book() {
        return new BookItemBuilder(this.validateMeta(BookMeta.class), this.getItemStack());
    }

    @NotNull
    public CrossbowItemBuilder crossbow() {
        if (Builder.VERSION < 14) {
            throw new IllegalStateException("The method called #crosbow() can only use 1.14 and later!");
        }
        return new CrossbowItemBuilder(this.validateMeta(CrossbowMeta.class), this.getItemStack());
    }

    @NotNull
    public FireworkItemBuilder firework() {
        return new FireworkItemBuilder(this.validateMeta(FireworkMeta.class), this.getItemStack());
    }

    @NotNull
    public LeatherArmorItemBuilder leatherArmor() {
        return new LeatherArmorItemBuilder(this.validateMeta(LeatherArmorMeta.class), this.getItemStack());
    }

    @NotNull
    public MapItemBuilder map() {
        return new MapItemBuilder(this.validateMeta(MapMeta.class), this.getItemStack());
    }

    @Override
    @NotNull
    public ItemStackBuilder self() {
        return this;
    }

    @NotNull
    public SkullItemBuilder skull() {
        return new SkullItemBuilder(this.validateMeta(SkullMeta.class), this.getItemStack());
    }

    @NotNull
    public SpawnEggItemBuilder spawnEgg() {
        return new SpawnEggItemBuilder(this.validateMeta(SpawnEggMeta.class), this.getItemStack());
    }

    @NotNull
    private <T extends ItemMeta> T validateMeta(@NotNull Class<T> meta) {
        if (!meta.isAssignableFrom(this.getItemMeta().getClass())) {
            throw new IllegalArgumentException(String.format("%s's meta is not a %s!", this.getItemStack(), meta.getSimpleName()));
        }
        return this.getItemMeta();
    }
}

