/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.bukkititembuilder;

import io.github.portlek.bukkititembuilder.Builder;
import java.util.Arrays;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BookItemBuilder
extends Builder<BookItemBuilder, BookMeta> {
    BookItemBuilder(@NotNull BookMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public BookItemBuilder addPages(String ... list) {
        return (BookItemBuilder)this.update(meta -> meta.addPage(list));
    }

    @Override
    @NotNull
    public BookItemBuilder self() {
        return this;
    }

    @NotNull
    public BookItemBuilder setAuthor(@Nullable String author) {
        return (BookItemBuilder)this.update(meta -> meta.setAuthor(author));
    }

    @NotNull
    public BookItemBuilder setGeneration(@Nullable BookMeta.Generation generation) {
        return (BookItemBuilder)this.update(meta -> meta.setGeneration(generation));
    }

    @NotNull
    public BookItemBuilder setPage(int page, @NotNull String text) {
        return (BookItemBuilder)this.update(meta -> meta.setPage(page, text));
    }

    @NotNull
    public BookItemBuilder setPages(String ... list) {
        return this.setPages(Arrays.asList(list));
    }

    @NotNull
    public BookItemBuilder setPages(@NotNull List<String> list) {
        return (BookItemBuilder)this.update(meta -> meta.setPages(list));
    }

    @NotNull
    public BookItemBuilder setTitle(@Nullable String title) {
        return (BookItemBuilder)this.update(meta -> meta.setTitle(title));
    }
}

