/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.wrappers;

public enum MathOperation {
    ADD("+="),
    ASSIGN("="),
    DIVIDE("/="),
    MAX(">"),
    MIN("<"),
    MOD("%="),
    MULTIPLY("*="),
    SUBTRACT("-="),
    SWAP("><");

    private String stringValue;

    private MathOperation(String stringValue) {
        this.stringValue = stringValue;
    }

    public String toString() {
        return this.stringValue;
    }

    public int apply(int val1, int val2) {
        switch (this) {
            case ADD: {
                return val1 + val2;
            }
            case ASSIGN: {
                return val2;
            }
            case DIVIDE: {
                return val1 / val2;
            }
            case MAX: {
                return Math.max(val1, val2);
            }
            case MIN: {
                return Math.min(val1, val2);
            }
            case MOD: {
                return val1 % val2;
            }
            case MULTIPLY: {
                return val1 * val2;
            }
            case SUBTRACT: {
                return val1 - val2;
            }
            case SWAP: {
                return val2;
            }
        }
        return val2;
    }

    public float apply(float val1, float val2) {
        switch (this) {
            case ADD: {
                return val1 + val2;
            }
            case ASSIGN: {
                return val2;
            }
            case DIVIDE: {
                return val1 / val2;
            }
            case MAX: {
                return Math.max(val1, val2);
            }
            case MIN: {
                return Math.min(val1, val2);
            }
            case MOD: {
                return val1 % val2;
            }
            case MULTIPLY: {
                return val1 * val2;
            }
            case SUBTRACT: {
                return val1 - val2;
            }
            case SWAP: {
                return val2;
            }
        }
        return val2;
    }
}

