/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.wrappers;

public class FloatRange {
    private final float low;
    private final float high;

    public FloatRange(float low, float high) {
        this.low = low;
        this.high = high;
    }

    public static FloatRange floatRangeGreaterThanOrEq(float min2) {
        return new FloatRange(min2, Float.MAX_VALUE);
    }

    public static FloatRange floatRangeLessThanOrEq(float max) {
        return new FloatRange(-3.4028235E38f, max);
    }

    public float getLowerBound() {
        return this.low;
    }

    public float getUpperBound() {
        return this.high;
    }

    public boolean isInRange(float f) {
        return f >= this.low && f <= this.high;
    }

    public String toString() {
        if (this.high == Float.MAX_VALUE) {
            return this.low + "..";
        }
        if (this.low == -3.4028235E38f) {
            return ".." + this.high;
        }
        return this.low + ".." + this.high;
    }
}

