/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.SafeOverrideableArgument;
import dev.jorel.commandapi.exceptions.InvalidRangeException;

public class LongArgument
extends SafeOverrideableArgument<Long> {
    public LongArgument(String nodeName) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg(), String::valueOf);
    }

    public LongArgument(String nodeName, long value) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg((long)value), String::valueOf);
    }

    public LongArgument(String nodeName, long min2, long max) {
        super(nodeName, (ArgumentType<?>)LongArgumentType.longArg((long)min2, (long)max), String::valueOf);
        if (max < min2) {
            throw new InvalidRangeException();
        }
    }

    @Override
    public Class<?> getPrimitiveType() {
        return Long.TYPE;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.PRIMITIVE_LONG;
    }
}

