/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.internal.CollectionInfoRetriever;
import com.mongodb.client.internal.CommandMarker;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.KeyManagementService;
import com.mongodb.client.internal.KeyRetriever;
import com.mongodb.client.internal.MongoClientImpl;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.crypt.capi.MongoCrypts;
import com.mongodb.internal.capi.MongoCryptHelper;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

public final class Crypts {
    public static Crypt createCrypt(MongoClientImpl client, AutoEncryptionSettings options) {
        MongoClient internalClient = null;
        MongoClientSettings keyVaultMongoClientSettings = options.getKeyVaultMongoClientSettings();
        if (keyVaultMongoClientSettings == null || !options.isBypassAutoEncryption()) {
            MongoClientSettings settings = MongoClientSettings.builder(client.getSettings()).applyToConnectionPoolSettings(builder -> builder.minSize(0)).autoEncryptionSettings(null).build();
            internalClient = MongoClients.create(settings);
        }
        MongoClient collectionInfoRetrieverClient = internalClient;
        MongoClient keyVaultClient = keyVaultMongoClientSettings == null ? internalClient : MongoClients.create(keyVaultMongoClientSettings);
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(options.getKmsProviders(), options.getSchemaMap())), options.isBypassAutoEncryption() ? null : new CollectionInfoRetriever(collectionInfoRetrieverClient), new CommandMarker(options.isBypassAutoEncryption(), options.getExtraOptions()), new KeyRetriever(keyVaultClient, new MongoNamespace(options.getKeyVaultNamespace())), Crypts.createKeyManagementService(), options.isBypassAutoEncryption(), internalClient);
    }

    static Crypt create(MongoClient keyVaultClient, ClientEncryptionSettings options) {
        return new Crypt(MongoCrypts.create((MongoCryptOptions)MongoCryptHelper.createMongoCryptOptions(options.getKmsProviders(), null)), Crypts.createKeyRetriever(keyVaultClient, options.getKeyVaultNamespace()), Crypts.createKeyManagementService());
    }

    private static KeyRetriever createKeyRetriever(MongoClient keyVaultClient, String keyVaultNamespaceString) {
        return new KeyRetriever(keyVaultClient, new MongoNamespace(keyVaultNamespaceString));
    }

    private static KeyManagementService createKeyManagementService() {
        return new KeyManagementService(Crypts.getSslContext(), 443, 10000);
    }

    private static SSLContext getSslContext() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
        return sslContext;
    }

    private Crypts() {
    }
}

