/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.utils;

import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.github.GitHub;
import tr.com.infumia.infumialib.paper.utils.TaskUtilities;

public final class GitHubUpdateChecker {
    public static void checkForUpdate(@NotNull Plugin plugin, @NotNull String organizationName, @NotNull String repositoryName) {
        GitHubUpdateChecker.checkForUpdate((CommandSender)Bukkit.getConsoleSender(), plugin, organizationName, repositoryName);
    }

    public static void checkForUpdate(@NotNull CommandSender sender, @NotNull Plugin plugin, @NotNull String organizationName, @NotNull String repositoryName) {
        TaskUtilities.async(() -> {
            try {
                String version = GitHub.connect().getOrganization(organizationName).getRepository(repositoryName).getLatestRelease().getTagName();
                String pluginVersion = plugin.getDescription().getVersion();
                if (!version.equals(pluginVersion)) {
                    sender.sendMessage((Component)GitHubUpdateChecker.createUpdateMessage0(plugin));
                    sender.sendMessage((Component)GitHubUpdateChecker.createUpdateMessage1(organizationName, repositoryName));
                }
            }
            catch (IOException e) {
                plugin.getSLF4JLogger().warn("Something went wrong when connecting to GitHub.", e);
            }
        });
    }

    @NotNull
    private static TextComponent createUpdateMessage0(@NotNull Plugin plugin) {
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text("[InfumiaPlugin] Update available for ").color(NamedTextColor.YELLOW))).append((Component)Component.text(plugin.getName()))).append(Component.text(" download the newest version here:").color(NamedTextColor.YELLOW))).build();
    }

    @NotNull
    private static TextComponent createUpdateMessage1(@NotNull String organizationName, @NotNull String repositoryName) {
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text("https://github.com/").color(NamedTextColor.GOLD))).append(Component.text(organizationName).color(NamedTextColor.GOLD))).append(Component.text("/").color(NamedTextColor.GOLD))).append(Component.text(repositoryName).color(NamedTextColor.GOLD))).append(Component.text("/releases/latest/").color(NamedTextColor.GOLD))).append(Component.text())).build();
    }

    private GitHubUpdateChecker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

