/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.paper.hooks.hooks;

import java.util.Optional;
import org.anjocaido.groupmanager.GroupManager;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Wrapped;

public final class GroupManagerWrapper
implements Wrapped {
    @NotNull
    private final GroupManager groupManager;

    @NotNull
    public Optional<String> getGroup(@NotNull String world, @NotNull Player player) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(player)).map(handler -> handler.getGroup(player.getName()));
    }

    @NotNull
    public Optional<String> getGroupPrefix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(world)).map(handler -> handler.getGroupPrefix(group));
    }

    @NotNull
    public Optional<String> getGroupSuffix(@NotNull String world, @NotNull String group) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(world)).map(handler -> handler.getGroupSuffix(group));
    }

    @NotNull
    public Optional<String> getUserPrefix(@NotNull Player player) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(player)).map(handler -> handler.getUserPrefix(player.getUniqueId().toString()));
    }

    @NotNull
    public Optional<String> getUserSuffix(@NotNull Player player) {
        return Optional.ofNullable(this.groupManager.getWorldsHolder().getWorldPermissions(player)).map(handler -> handler.getUserSuffix(player.getUniqueId().toString()));
    }

    public GroupManagerWrapper(@NotNull GroupManager groupManager) {
        if (groupManager == null) {
            throw new NullPointerException("groupManager is marked non-null but is null");
        }
        this.groupManager = groupManager;
    }
}

