/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public abstract class GHHook
extends GHObject {
    String name;
    List<String> events;
    boolean active;
    Map<String, String> config;

    public String getName() {
        return this.name;
    }

    public EnumSet<GHEvent> getEvents() {
        EnumSet<GHEvent> s2 = EnumSet.noneOf(GHEvent.class);
        for (String e : this.events) {
            if (e.equals("*")) {
                s2.add(GHEvent.ALL);
                continue;
            }
            s2.add(Enum.valueOf(GHEvent.class, e.toUpperCase(Locale.ENGLISH)));
        }
        return s2;
    }

    public boolean isActive() {
        return this.active;
    }

    public Map<String, String> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public void ping() throws IOException {
        ((Requester)((Requester)this.getRoot().createRequest().method("POST")).withUrlPath(this.getApiRoute() + "/pings", new String[0])).send();
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.getRoot().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    @Override
    abstract GitHub getRoot();

    abstract String getApiRoute();
}

