/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.versionmatched;

import com.google.common.base.Preconditions;
import io.github.portlek.bukkitversion.BukkitVersion;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

final class VersionClass<T> {
    private static final char[] NUMBERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    @NotNull
    private final String rawClassName;
    @NotNull
    private final Class<? extends T> versionClass;

    VersionClass(@NotNull Class<? extends T> versionClass) {
        this(versionClass.getSimpleName(), versionClass);
    }

    boolean match(@NotNull BukkitVersion version) {
        return this.version().equals(version);
    }

    @NotNull
    private BukkitVersion version() {
        int sub = this.versionSubString();
        Preconditions.checkState((sub != -1 ? 1 : 0) != 0, (String)"version() -> Invalid name for \"%s\"", (Object)this.rawClassName);
        return new BukkitVersion(this.rawClassName.substring(sub));
    }

    private int versionSubString() {
        AtomicInteger subString = new AtomicInteger();
        block0: for (char name : this.rawClassName.toCharArray()) {
            for (char number : NUMBERS) {
                if (name == number) break block0;
            }
            subString.incrementAndGet();
        }
        return subString.get();
    }

    public VersionClass(@NotNull String rawClassName, @NotNull Class<? extends T> versionClass) {
        if (rawClassName == null) {
            throw new NullPointerException("rawClassName is marked non-null but is null");
        }
        if (versionClass == null) {
            throw new NullPointerException("versionClass is marked non-null but is null");
        }
        this.rawClassName = rawClassName;
        this.versionClass = versionClass;
    }

    @NotNull
    public Class<? extends T> getVersionClass() {
        return this.versionClass;
    }
}

