/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.listener;

import io.github.portlek.smartinventory.SmartInventory;
import io.github.portlek.smartinventory.event.PlyrQuitEvent;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public final class PlayerQuitListener
implements Listener {
    @NotNull
    private final Consumer<UUID> stopTickFunction;

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        SmartInventory.getHolder(event.getPlayer()).ifPresent(holder -> {
            holder.getPage().accept(new PlyrQuitEvent(holder.getContents(), event));
            this.stopTickFunction.accept(event.getPlayer().getUniqueId());
        });
    }

    public PlayerQuitListener(@NotNull Consumer<UUID> stopTickFunction) {
        if (stopTickFunction == null) {
            throw new NullPointerException("stopTickFunction is marked non-null but is null");
        }
        this.stopTickFunction = stopTickFunction;
    }
}

