/*
 * Decompiled with CFR 0.152.
 */
package io.github.portlek.smartinventory.listener;

import io.github.portlek.smartinventory.Icon;
import io.github.portlek.smartinventory.InventoryContents;
import io.github.portlek.smartinventory.SmartHolder;
import io.github.portlek.smartinventory.event.IcDragEvent;
import io.github.portlek.smartinventory.util.SlotPos;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public final class InventoryDragListener
implements Listener {
    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof SmartHolder)) {
            return;
        }
        SmartHolder smartHolder = (SmartHolder)holder;
        Inventory inventory = event.getInventory();
        InventoryContents contents = smartHolder.getContents();
        for (Integer slot : event.getRawSlots()) {
            SlotPos pos = SlotPos.of(slot / 9, slot % 9);
            contents.get(pos).ifPresent(icon -> icon.accept(new IcDragEvent(contents, event, (Icon)icon, smartHolder.getPlugin())));
            if (slot >= inventory.getSize() || contents.isEditable(pos)) continue;
            event.setCancelled(true);
            break;
        }
    }
}

